/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload;

import ch.ethz.sis.filetransfer.DefaultDeserializerProvider;
import ch.ethz.sis.filetransfer.DefaultRetryProvider;
import ch.ethz.sis.filetransfer.DownloadClient;
import ch.ethz.sis.filetransfer.DownloadClientConfig;
import ch.ethz.sis.filetransfer.DownloadClientDownload;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadItemId;
import ch.ethz.sis.filetransfer.DownloadItemNotFoundException;
import ch.ethz.sis.filetransfer.DownloadPreferences;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.FileSystemDownloadStore;
import ch.ethz.sis.filetransfer.IDeserializerProvider;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadItemIdDeserializer;
import ch.ethz.sis.filetransfer.IDownloadListener;
import ch.ethz.sis.filetransfer.IDownloadServer;
import ch.ethz.sis.filetransfer.IDownloadStore;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.IRetryProvider;
import ch.ethz.sis.filetransfer.IRetryProviderFactory;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.NullLogger;
import ch.ethz.sis.filetransfer.UserSessionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSession;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadSessionOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.DataSetFilePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.IDataSetFileId;
import ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload.FastDownloadResult;
import ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload.RemoteFastDownloadServer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FastDownloader {
    private IDownloadServer downloadServer;
    private ILogger logger;
    private List<IDownloadListener> listeners = new ArrayList<IDownloadListener>();
    private IRetryProviderFactory retryProviderFactory;
    private UserSessionId userSessionId;
    private FastDownloadSessionOptions downLoadOptions;
    private List<IDownloadItemId> downloadItems;
    private String downLoadUrl;

    public FastDownloader(FastDownloadSession session) {
        this(new RemoteFastDownloadServer(session.getDownloadUrl()), session.getDownloadUrl(), session.getFileTransferUserSessionId(), session.getOptions(), session.getFiles());
    }

    FastDownloader(IDownloadServer downloadServer, String downLoadUrl, String FileTransferUserSessionId, FastDownloadSessionOptions downLoadOptions, List<IDataSetFileId> files) {
        this.downloadServer = downloadServer;
        this.downLoadUrl = downLoadUrl;
        this.downLoadOptions = downLoadOptions;
        this.userSessionId = new UserSessionId(FileTransferUserSessionId);
        this.downloadItems = files.stream().map(fid -> FastDownloader.createId(fid)).collect(Collectors.toList());
    }

    private static final IDownloadItemId createId(IDataSetFileId dataSetFileId) {
        if (!(dataSetFileId instanceof DataSetFilePermId)) {
            throw new IllegalArgumentException("Unsupported fileId: " + dataSetFileId);
        }
        DataSetFilePermId filePermId = (DataSetFilePermId)dataSetFileId;
        IDataSetId dataSetId = filePermId.getDataSetId();
        if (!(dataSetId instanceof DataSetPermId)) {
            throw new IllegalArgumentException("Unsupported dataSetId: " + dataSetId);
        }
        return new DownloadItemId(((DataSetPermId)dataSetId).getPermId() + "/" + filePermId.getFilePath());
    }

    public IDownloadServer getDownloadServer() {
        if (this.downloadServer == null) {
            this.downloadServer = new RemoteFastDownloadServer(this.downLoadUrl);
        }
        return this.downloadServer;
    }

    public FastDownloader withLogger(ILogger logger) {
        this.logger = logger;
        return this;
    }

    public FastDownloader withListener(IDownloadListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public FastDownloader withRetryProviderFactory(IRetryProviderFactory retryProviderFactory) {
        this.retryProviderFactory = retryProviderFactory;
        return this;
    }

    public FastDownloadResult downloadTo(File folder) {
        DownloadClient client = this.createDownloadClient(folder.toPath());
        DownloadClientDownload download = client.createDownload((IUserSessionId)this.userSessionId);
        for (IDownloadListener listener : this.listeners) {
            download.addListener(listener);
        }
        download.addItems(this.downloadItems);
        download.setPreferences(this.createPreferences(this.downLoadOptions));
        download.start();
        download.await();
        return new FastDownloadResult(download);
    }

    private DownloadClient createDownloadClient(final Path root) {
        ILogger actualLogger = this.logger != null ? this.logger : new NullLogger();
        DownloadClientConfig config = new DownloadClientConfig();
        config.setServer(this.getDownloadServer());
        config.setLogger(actualLogger);
        config.setStore((IDownloadStore)new FileSystemDownloadStore(actualLogger, root){

            protected Path getItemDirectory(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, IDownloadItemId itemId) throws DownloadException {
                String[] splitted = itemId.getId().split("/", 2);
                String dataSetCode = splitted[0];
                return root.resolve(dataSetCode);
            }

            public Path getItemPath(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, IDownloadItemId itemId) throws DownloadException {
                String[] splitted;
                Path itemDirectory = this.getItemDirectory(userSessionId, downloadSessionId, itemId);
                Path itemPath = itemDirectory.resolve((splitted = itemId.getId().split("/", 2))[1]);
                if (itemPath.toFile().exists()) {
                    return itemPath;
                }
                throw new DownloadItemNotFoundException("Store does not contain any files for download item id: " + itemId);
            }
        });
        config.setDeserializerProvider((IDeserializerProvider)new DefaultDeserializerProvider(actualLogger, new IDownloadItemIdDeserializer(){

            public IDownloadItemId deserialize(ByteBuffer buffer) throws DownloadException {
                return new DownloadItemId(new String(buffer.array(), buffer.position(), buffer.limit()));
            }
        }));
        config.setRetryProvider((IRetryProvider)(this.retryProviderFactory != null ? this.retryProviderFactory.createRetryProvider(actualLogger) : new DefaultRetryProvider(actualLogger, 3, 1000, 2)));
        return new DownloadClient(config);
    }

    private DownloadPreferences createPreferences(FastDownloadSessionOptions options) {
        return new DownloadPreferences(options.getWishedNumberOfStreams());
    }

    public String toString() {
        return new ObjectToString(this).append("downLoadUrl", this.downLoadUrl).append("userSessionId", this.userSessionId).toString();
    }
}

