/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

@JsonObject(value="Project")
public final class Project
implements Serializable,
IIdentifierHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String permId;
    private String spaceCode;
    private String code;
    private String description;
    private EntityRegistrationDetails registrationDetails;

    public Project(Long id, String permId, String spaceCode, String code, String description) {
        this(id, permId, spaceCode, code, description, null);
    }

    public Project(String spaceCode, String code) {
        this(spaceCode, code, null);
    }

    public Project(String spaceCode, String code, EntityRegistrationDetails registrationDetails) {
        this.checkAndSetCodes(spaceCode, code);
        this.registrationDetails = registrationDetails;
    }

    public Project(Long id, String permId, String spaceCode, String code, String description, EntityRegistrationDetails registrationDetails) {
        if (id == null || id == 0L) {
            throw new IllegalArgumentException("Unspecified tech id.");
        }
        this.id = id;
        if (permId == null || permId.length() == 0) {
            throw new IllegalArgumentException("Unspecified permanent id.");
        }
        this.permId = permId;
        this.checkAndSetCodes(spaceCode, code);
        this.description = description;
        this.registrationDetails = registrationDetails;
    }

    private void checkAndSetCodes(String spaceCode, String code) {
        if (spaceCode == null || spaceCode.length() == 0) {
            throw new IllegalArgumentException("Unspecified space code.");
        }
        this.spaceCode = spaceCode;
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Unspecified code.");
        }
        this.code = code;
    }

    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        return "/" + this.spaceCode + "/" + this.code;
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.permId == null ? 0 : this.permId.hashCode());
        result = 31 * result + (this.registrationDetails == null ? 0 : this.registrationDetails.hashCode());
        result = 31 * result + (this.spaceCode == null ? 0 : this.spaceCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.permId == null ? other.permId != null : !this.permId.equals(other.permId)) {
            return false;
        }
        if (this.registrationDetails == null ? other.registrationDetails != null : !this.registrationDetails.equals(other.registrationDetails)) {
            return false;
        }
        return !(this.spaceCode == null ? other.spaceCode != null : !this.spaceCode.equals(other.spaceCode));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getIdentifier());
        if (this.permId != null || this.id != null) {
            buf.append('[');
            if (this.getPermId() != null) {
                buf.append(this.getPermId());
            }
            if (this.getId() != null) {
                buf.append("(" + this.getId() + ")");
            }
            buf.append(']');
        }
        return this.getIdentifier();
    }

    private Project() {
    }

    @JsonIgnore
    private void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }

    private void setPermId(String permId) {
        this.permId = permId;
    }

    private void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }
}

