/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import java.io.Serializable;

@JsonObject(value="Role")
public final class Role
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private boolean spaceLevel;

    public Role(String code, boolean spaceLevel) {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Unspecified code.");
        }
        this.code = code;
        this.spaceLevel = spaceLevel;
    }

    public final String getCode() {
        return this.code;
    }

    public final boolean isSpaceLevel() {
        return this.spaceLevel;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role role = (Role)obj;
        return role.spaceLevel == this.spaceLevel && role.code.equals(this.code);
    }

    public int hashCode() {
        return 37 * this.code.hashCode() + (this.spaceLevel ? 1 : 0);
    }

    public String toString() {
        return this.code + "(" + (this.spaceLevel ? "space" : "instance") + ")";
    }

    private Role() {
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setSpaceLevel(boolean spaceLevel) {
        this.spaceLevel = spaceLevel;
    }
}

