/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonObject(value="VocabularyGeneric")
public class Vocabulary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String code;
    private String description;
    private boolean managedInternally;
    private boolean chosenFromList;
    private String urlTemplate;
    private List<VocabularyTerm> terms;

    public Vocabulary(VocabularyInitializer initializer) {
        InitializingChecks.checkValidLong(initializer.id, "Unspecified id.");
        this.id = initializer.id;
        InitializingChecks.checkValidString(initializer.code, "Unspecified code.");
        this.code = initializer.code;
        this.description = initializer.description;
        this.chosenFromList = initializer.chosenFromList;
        this.managedInternally = initializer.managedInternally;
        this.urlTemplate = initializer.urlTemplate;
        this.terms = initializer.terms == null ? Collections.emptyList() : initializer.terms;
    }

    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public boolean isInternalNamespace() {
        return this.isManagedInternally();
    }

    public boolean isChosenFromList() {
        return this.chosenFromList;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public List<VocabularyTerm> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vocabulary)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Vocabulary other = (Vocabulary)obj;
        builder.append((Object)this.getId(), (Object)other.getId());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getCode());
        builder.append(this.getTerms());
        return builder.toString();
    }

    private Vocabulary() {
    }

    @JsonIgnore
    private void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    private void setInternalNamespace(boolean internalNamespace) {
        this.setManagedInternally(internalNamespace);
    }

    private void setChosenFromList(boolean chosenFromList) {
        this.chosenFromList = chosenFromList;
    }

    private void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    private void setTerms(List<VocabularyTerm> terms) {
        this.terms = terms;
    }

    public static class VocabularyInitializer {
        private Long id;
        private String code;
        private String description;
        private boolean managedInternally;
        private boolean chosenFromList;
        private String urlTemplate;
        private List<VocabularyTerm> terms;

        public void setId(Long id) {
            this.id = id;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setManagedInternally(boolean managedInternally) {
            this.managedInternally = managedInternally;
        }

        public void setChosenFromList(boolean chosenFromList) {
            this.chosenFromList = chosenFromList;
        }

        public void setUrlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }

        public void setTerms(List<VocabularyTerm> terms) {
            this.terms = terms;
        }
    }
}

