/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication;

import ch.systemsx.cisd.authentication.Principal;
import java.io.Serializable;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BasicSession
implements Serializable {
    protected static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private String sessionToken;
    private String userName;
    private Principal principal;
    private String remoteHost;
    private long sessionStart;
    private int sessionExpirationTime;

    @Deprecated
    public BasicSession() {
    }

    public BasicSession(String sessionToken, String userName, Principal principal, String remoteHost, long sessionStart, int sessionExpirationTime) {
        assert (sessionToken != null) : "Given session token can not be null.";
        assert (userName != null) : "Given user name can not be null.";
        assert (principal != null) : "Given principal can not be null.";
        assert (sessionStart > 0L) : "Given session start must be larger than zero.";
        assert (remoteHost != null) : "Given remote host can not be null";
        assert (sessionExpirationTime >= 0);
        this.sessionToken = sessionToken;
        this.userName = userName;
        this.principal = principal;
        this.remoteHost = remoteHost;
        this.sessionStart = sessionStart;
        this.sessionExpirationTime = sessionExpirationTime;
    }

    public final String getSessionToken() {
        return this.sessionToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public final Principal getPrincipal() {
        return this.principal;
    }

    public final boolean isAnonymous() {
        return this.principal.isAnonymous();
    }

    public final String getRemoteHost() {
        return this.remoteHost;
    }

    public final long getSessionStart() {
        return this.sessionStart;
    }

    public final int getSessionExpirationTime() {
        return this.sessionExpirationTime;
    }

    public void cleanup() {
    }

    @Deprecated
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Deprecated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Deprecated
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    @Deprecated
    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    @Deprecated
    public void setSessionStart(long sessionStart) {
        this.sessionStart = sessionStart;
    }

    @Deprecated
    public void setSessionExpirationTime(int sessionExpirationTime) {
        this.sessionExpirationTime = sessionExpirationTime;
    }

    public String toString() {
        return "BasicSession{user=" + this.userName + ",remoteHost=" + this.remoteHost + ",sessionstart=" + DateFormatUtils.format((long)this.sessionStart, (String)DATE_FORMAT_PATTERN) + "}";
    }
}

