/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.file.CachingAuthenticationConfiguration;
import ch.systemsx.cisd.authentication.file.FileBasedLineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.LineBasedUserStore;
import ch.systemsx.cisd.authentication.file.UserCacheEntry;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.io.File;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CachingAuthenticationService
implements IAuthenticationService {
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long CACHE_TIME_MILLIS_NO_REVALIDATION = 3600000L;
    public static final long CACHE_TIME_MILLIS = 100800000L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CachingAuthenticationService.class);
    private final IUserStore<UserCacheEntry> userStore;
    private final IAuthenticationService delegate;
    private final IAuthenticator userIdAuthenticator;
    private final IAuthenticator emailAuthenticator;
    private final long cacheTimeNoRevalidationMillis;
    private final long cacheTimeMillis;
    private final BlockingQueue<ValidationRequest> validationQueue;
    private final ITimeProvider timeProvider;
    private final boolean caching;

    public CachingAuthenticationService(IAuthenticationService delegate, String passwordCacheFileName) {
        this(delegate, CachingAuthenticationService.createUserStore(passwordCacheFileName));
    }

    public CachingAuthenticationService(IAuthenticationService authenticationService, IUserStore<UserCacheEntry> store) {
        this(authenticationService, store, 3600000L, 100800000L);
    }

    public CachingAuthenticationService(IAuthenticationService delegate, String passwordCacheFileName, long cacheTimeNoRevalidationMillis, long cacheTimeMillis) {
        this(delegate, CachingAuthenticationService.createUserStore(passwordCacheFileName), cacheTimeNoRevalidationMillis, cacheTimeMillis);
    }

    public CachingAuthenticationService(IAuthenticationService delegate, IUserStore<UserCacheEntry> userStore, long cacheTimeNoRevalidationMillis, long cacheTimeMillis) {
        this(delegate, userStore, cacheTimeNoRevalidationMillis, cacheTimeMillis, true, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    public CachingAuthenticationService(CachingAuthenticationConfiguration config) {
        this(config.getDelegate(), CachingAuthenticationService.createUserStore(config.getPasswordCacheFile()), config.getCacheTimeNoRevalidation(), config.getCacheTime());
    }

    CachingAuthenticationService(IAuthenticationService delegate, IUserStore<UserCacheEntry> userStore, long cacheTimeNoRevalidationMillis, long cacheTimeMillis, boolean startRevalidationThread, ITimeProvider timeProvider) {
        this.delegate = delegate;
        this.userIdAuthenticator = new IAuthenticator(){

            @Override
            public Principal tryGetAndAuthenticate(String userId, String passwordOrNull) {
                return CachingAuthenticationService.this.delegate.tryGetAndAuthenticateUser(userId, passwordOrNull);
            }
        };
        this.emailAuthenticator = new IAuthenticator(){

            @Override
            public Principal tryGetAndAuthenticate(String email, String passwordOrNull) {
                return CachingAuthenticationService.this.delegate.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
            }
        };
        this.userStore = userStore;
        this.cacheTimeNoRevalidationMillis = Math.min(cacheTimeNoRevalidationMillis, cacheTimeMillis);
        this.cacheTimeMillis = cacheTimeMillis;
        this.validationQueue = new LinkedBlockingQueue<ValidationRequest>();
        this.timeProvider = timeProvider;
        boolean bl = this.caching = cacheTimeMillis > 0L;
        if (startRevalidationThread && this.caching) {
            Thread t = new Thread(new RevalidationRunnable());
            t.setName(this.getClass().getSimpleName() + " - Validator");
            t.setDaemon(true);
            t.start();
        }
        if (operationLog.isInfoEnabled()) {
            if (this.caching) {
                operationLog.info((Object)String.format("Caching authentication results for %s, revalidating after %s.", DateTimeUtils.renderDuration((long)cacheTimeMillis), DateTimeUtils.renderDuration((long)cacheTimeNoRevalidationMillis)));
            } else {
                operationLog.info((Object)"Authentication caching is switched off.");
            }
        }
    }

    static IUserStore<UserCacheEntry> createUserStore(String passwordCacheFileName) {
        if (StringUtils.isBlank((CharSequence)passwordCacheFileName)) {
            return null;
        }
        return CachingAuthenticationService.createUserStore(new File(passwordCacheFileName));
    }

    static IUserStore<UserCacheEntry> createUserStore(File passwordCacheFile) {
        if (passwordCacheFile == null) {
            return null;
        }
        FileBasedLineStore lineStore = new FileBasedLineStore(passwordCacheFile, "Password cache file");
        return new LineBasedUserStore<UserCacheEntry>(lineStore, new LineBasedUserStore.IUserEntryFactory<UserCacheEntry>(){

            @Override
            public UserCacheEntry create(String line) {
                return new UserCacheEntry(line);
            }
        });
    }

    BlockingQueue<ValidationRequest> getValidationQueue() {
        return this.validationQueue;
    }

    @Override
    public boolean authenticateUser(String userId, String password) {
        return Principal.isAuthenticated(this.tryGetAndAuthenticateUser(userId, password, this.userIdAuthenticator, this.userStore.tryGetUserById(userId)));
    }

    private Principal tryGetAndAuthenticateUser(String id, String passwordOrNull, IAuthenticator auth, UserCacheEntry entry) {
        boolean requiresAuthentication = StringUtils.isNotEmpty((CharSequence)passwordOrNull);
        long now = this.timeProvider.getTimeInMilliseconds();
        CacheEntryStatus state = this.getStatus(entry, requiresAuthentication, now);
        switch (state) {
            case OK: {
                boolean authenticated = entry.isPasswordCorrect(passwordOrNull);
                if (!authenticated && requiresAuthentication) {
                    this.validationQueue.offer(new ValidationRequest(entry, passwordOrNull, false, now));
                }
                return CachingAuthenticationService.toPrincipal(entry, authenticated);
            }
            case OK_REVALIDATE: {
                boolean authenticated = entry.isPasswordCorrect(passwordOrNull);
                this.validationQueue.offer(new ValidationRequest(entry, passwordOrNull, authenticated, now));
                return CachingAuthenticationService.toPrincipal(entry, authenticated);
            }
            case NO_ENTRY: {
                Principal p = auth.tryGetAndAuthenticate(id, passwordOrNull);
                if (p == null) {
                    return null;
                }
                if (this.caching) {
                    UserCacheEntry user = new UserCacheEntry(p, passwordOrNull, this.timeProvider.getTimeInMilliseconds());
                    this.userStore.addOrUpdateUser(user);
                }
                return p;
            }
        }
        throw new Error("Unknown cache entry state " + (Object)((Object)state));
    }

    private static Principal toPrincipal(UserEntry userOrNull, boolean authenticated) {
        if (userOrNull == null) {
            return null;
        }
        Principal principal = userOrNull.asPrincipal();
        principal.setAuthenticated(authenticated);
        return principal;
    }

    private CacheEntryStatus getStatus(UserCacheEntry entry, boolean requirePassword, long now) {
        if (entry == null || !this.caching) {
            return CacheEntryStatus.NO_ENTRY;
        }
        if (requirePassword && !entry.hasPassword()) {
            return CacheEntryStatus.NO_ENTRY;
        }
        long cachedAt = entry.getCachedAt();
        if (cachedAt + this.cacheTimeNoRevalidationMillis >= now) {
            return CacheEntryStatus.OK;
        }
        if (cachedAt + this.cacheTimeMillis >= now) {
            return CacheEntryStatus.OK_REVALIDATE;
        }
        return CacheEntryStatus.NO_ENTRY;
    }

    @Override
    @Deprecated
    public boolean authenticateUser(String dummyToken, String userId, String password) {
        return this.authenticateUser(userId, password);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String userId, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(userId, passwordOrNull, this.userIdAuthenticator, this.userStore.tryGetUserById(userId));
    }

    @Override
    @Deprecated
    public Principal tryGetAndAuthenticateUser(String dummyToken, String userId, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(userId, passwordOrNull);
    }

    @Override
    public Principal getPrincipal(String userId) throws IllegalArgumentException {
        Principal principalOrNull = this.tryGetAndAuthenticateUser(userId, null, this.userIdAuthenticator, this.userStore.tryGetUserById(userId));
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + userId + "'.");
        }
        return principalOrNull;
    }

    @Override
    @Deprecated
    public Principal getPrincipal(String dummyToken, String userId) throws IllegalArgumentException {
        return this.getPrincipal(userId);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(email, passwordOrNull, this.emailAuthenticator, this.userStore.tryGetUserByEmail(email));
    }

    @Override
    @Deprecated
    public Principal tryGetAndAuthenticateUserByEmail(String dummyToken, String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
    }

    @Override
    public boolean supportsAuthenticatingByEmail() {
        return this.delegate.supportsAuthenticatingByEmail();
    }

    @Override
    public boolean supportsListingByUserId() {
        return this.delegate.supportsListingByUserId();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public boolean supportsListingByEmail() {
        return this.delegate.supportsListingByEmail();
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public boolean supportsListingByLastName() {
        return this.delegate.supportsListingByLastName();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    @Deprecated
    public String authenticateApplication() {
        return this.delegate.authenticateApplication();
    }

    @Override
    @Deprecated
    public List<Principal> listPrincipalsByUserId(String dummyToken, String userIdQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByUserId(dummyToken, userIdQuery);
    }

    @Override
    @Deprecated
    public List<Principal> listPrincipalsByEmail(String dummyToken, String emailQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByEmail(dummyToken, emailQuery);
    }

    @Override
    @Deprecated
    public List<Principal> listPrincipalsByLastName(String dummyToken, String lastNameQuery) throws IllegalArgumentException {
        return this.delegate.listPrincipalsByLastName(dummyToken, lastNameQuery);
    }

    public boolean isRemote() {
        return this.delegate.isRemote();
    }

    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.userStore.check();
        this.delegate.check();
    }

    @Override
    public boolean isConfigured() {
        return this.userStore != null && this.delegate != null && this.delegate.isConfigured();
    }

    static interface IAuthenticator {
        public Principal tryGetAndAuthenticate(String var1, String var2);
    }

    final class RevalidationRunnable
    implements Runnable {
        RevalidationRunnable() {
        }

        void runOnce() throws InterruptedException {
            ValidationRequest request = (ValidationRequest)CachingAuthenticationService.this.validationQueue.take();
            if (!request.isValid()) {
                return;
            }
            String userId = request.getUser().getUserId();
            Principal p = CachingAuthenticationService.this.delegate.tryGetAndAuthenticateUser(userId, request.tryGetPassword());
            if (p == null) {
                CachingAuthenticationService.this.userStore.removeUser(userId);
                if (request.isAuthenticated()) {
                    operationLog.warn((Object)String.format("User '%s' has been logged in which is no longer a valid user.", userId));
                }
                return;
            }
            if (p.isAuthenticated() || request.withoutAuthentication()) {
                CachingAuthenticationService.this.userStore.addOrUpdateUser(new UserCacheEntry(p, request.tryGetPassword(), CachingAuthenticationService.this.timeProvider.getTimeInMilliseconds()));
            }
            if (request.isAuthenticated() && !p.isAuthenticated()) {
                CachingAuthenticationService.this.userStore.removeUser(userId);
                operationLog.warn((Object)String.format("User '%s' has been logged in with an outdated password.", userId));
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.runOnce();
                    }
                }
                catch (Throwable th) {
                    operationLog.error((Object)("Exception in " + CachingAuthenticationService.class.getSimpleName() + " Revalidator: "), th);
                    continue;
                }
                break;
            }
        }
    }

    final class ValidationRequest {
        private final UserCacheEntry user;
        private final long queuedAt;
        private final String passwordOrNull;
        private final boolean authenticated;

        ValidationRequest(UserCacheEntry user, String passwordOrNull, boolean authenticated, long now) {
            this.user = user;
            this.passwordOrNull = passwordOrNull;
            this.authenticated = authenticated;
            this.queuedAt = now;
        }

        UserCacheEntry getUser() {
            return this.user;
        }

        String tryGetPassword() {
            return this.passwordOrNull;
        }

        boolean withoutAuthentication() {
            return this.passwordOrNull == null;
        }

        boolean isAuthenticated() {
            return this.authenticated;
        }

        boolean isValid() {
            UserCacheEntry current = (UserCacheEntry)((Object)CachingAuthenticationService.this.userStore.tryGetUserById(this.user.getUserId()));
            if (current == null) {
                return true;
            }
            if (this.passwordOrNull == null && current.hasPassword()) {
                return false;
            }
            if (this.passwordOrNull != null && !current.hasPassword()) {
                return true;
            }
            return current.getCachedAt() < this.queuedAt;
        }
    }

    private static enum CacheEntryStatus {
        OK,
        OK_REVALIDATE,
        NO_ENTRY;

    }
}

