/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.file.FileBasedLineStore;
import ch.systemsx.cisd.authentication.file.ILineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.LineBasedUserStore;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.authentication.file.UserEntryAuthenticationState;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class FileAuthenticationService
implements IAuthenticationService {
    private static final String DUMMY_TOKEN_STR = "DUMMY-TOKEN";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileAuthenticationService.class);
    private final IUserStore<UserEntry> userStore;
    private final IAuthenticationService listingServiceOrNull;

    static IUserStore<UserEntry> createUserStore(String passwordFileName) {
        if (StringUtils.isBlank((String)passwordFileName)) {
            return null;
        }
        return FileAuthenticationService.createUserStore(new File(passwordFileName));
    }

    static IUserStore<UserEntry> createUserStore(File passwordFile) {
        if (passwordFile == null) {
            return null;
        }
        FileBasedLineStore lineStore = new FileBasedLineStore(passwordFile, "Password file");
        return FileAuthenticationService.createUserStore(lineStore);
    }

    static IUserStore<UserEntry> createUserStore(ILineStore lineStore) {
        return new LineBasedUserStore<UserEntry>(lineStore, new LineBasedUserStore.IUserEntryFactory<UserEntry>(){

            @Override
            public UserEntry create(String line) {
                return new UserEntry(line);
            }
        });
    }

    public FileAuthenticationService(String passwordFileName) {
        this(FileAuthenticationService.createUserStore(passwordFileName), null);
    }

    public FileAuthenticationService(IUserStore<UserEntry> userStore, IAuthenticationService listingServiceOrNull) {
        this.userStore = userStore;
        this.listingServiceOrNull = listingServiceOrNull;
    }

    @Override
    public String authenticateApplication() {
        return DUMMY_TOKEN_STR;
    }

    @Override
    public boolean authenticateUser(String dummyToken, String user, String password) {
        return this.authenticateUser(user, password);
    }

    @Override
    public boolean authenticateUser(String userId, String password) {
        boolean authenticated = this.userStore.isPasswordCorrect(userId, password);
        this.logAuthentication(userId, authenticated);
        return authenticated;
    }

    private void logAuthentication(String user, boolean authenticated) {
        if (operationLog.isInfoEnabled()) {
            String msg = "FILE: authentication of user '" + user + "': ";
            operationLog.info((Object)(msg + (authenticated ? "SUCCESS." : "FAILED.")));
        }
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String dummyToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String userId, String passwordOrNull) {
        Principal principal = FileAuthenticationService.toPrincipal(this.userStore.tryGetAndAuthenticateUserById(userId, passwordOrNull));
        this.logAuthentication(userId, Principal.isAuthenticated(principal));
        return principal;
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        Principal principal = FileAuthenticationService.toPrincipal(this.userStore.tryGetAndAuthenticateUserByEmail(email, passwordOrNull));
        String user = principal != null ? principal.getUserId() : "email:" + email;
        this.logAuthentication(user, Principal.isAuthenticated(principal));
        return principal;
    }

    static Principal toPrincipal(UserEntryAuthenticationState<? extends UserEntry> entryOrNull) {
        if (entryOrNull == null) {
            return null;
        }
        UserEntry user = entryOrNull.getUserEntry();
        Principal principal = user.asPrincipal();
        principal.setAuthenticated(entryOrNull.isAuthenticated());
        return principal;
    }

    static Principal toPrincipal(UserEntry userOrNull) {
        if (userOrNull == null) {
            return null;
        }
        return userOrNull.asPrincipal();
    }

    @Override
    public Principal getPrincipal(String applicationToken, String userId) {
        return this.getPrincipal(userId);
    }

    @Override
    public Principal getPrincipal(String userId) {
        Principal principalOrNull = FileAuthenticationService.toPrincipal(this.userStore.tryGetUserById(userId));
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + userId + "'.");
        }
        return principalOrNull;
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByEmail(emailQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByEmail(emailQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByLastName(lastNameQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByLastName(lastNameQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String dummyToken, String userIdQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByUserId(userIdQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        if (this.listingServiceOrNull != null) {
            return this.listingServiceOrNull.listPrincipalsByUserId(userIdQuery);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsListingByEmail() {
        return this.listingServiceOrNull != null && this.listingServiceOrNull.supportsListingByEmail();
    }

    @Override
    public boolean supportsListingByLastName() {
        return this.listingServiceOrNull != null && this.listingServiceOrNull.supportsListingByLastName();
    }

    @Override
    public boolean supportsListingByUserId() {
        return this.listingServiceOrNull != null && this.listingServiceOrNull.supportsListingByUserId();
    }

    @Override
    public boolean supportsAuthenticatingByEmail() {
        return true;
    }

    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.userStore.check();
        if (this.listingServiceOrNull != null) {
            this.listingServiceOrNull.check();
        }
    }

    public boolean isRemote() {
        return this.listingServiceOrNull != null && this.listingServiceOrNull.isRemote();
    }

    @Override
    public boolean isConfigured() {
        return this.userStore != null;
    }
}

