/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.file.ILineStore;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

final class FileBasedLineStore
implements ILineStore {
    private static final Logger machineLog = LogFactory.getLogger((LogCategory)LogCategory.MACHINE, FileBasedLineStore.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileBasedLineStore.class);
    private final File file;
    private final File oldFile;
    private final File newFile;
    private final String fileDescription;
    private long lastReadTimestamp;

    FileBasedLineStore(File file, String fileDescription) {
        this.file = file;
        this.oldFile = new File(file.getPath() + ".sv");
        this.newFile = new File(file.getPath() + ".tmp");
        this.fileDescription = fileDescription;
    }

    @Override
    public void check() throws ConfigurationFailureException {
        try {
            this.checkWritable();
        }
        catch (EnvironmentFailureException ex) {
            throw new ConfigurationFailureException(ex.getMessage());
        }
        if (!this.file.canRead()) {
            String msg = String.format(this.file.exists() ? "%s '%s' is not readable." : "%s '%s' does not exist.", this.fileDescription, this.file.getAbsolutePath());
            operationLog.error((Object)msg);
            throw new ConfigurationFailureException(msg);
        }
    }

    private static void checkWritable(File file, String fileDescription) throws EnvironmentFailureException {
        if (!file.exists()) {
            try {
                FileUtils.touch((File)file);
            }
            catch (IOException ex) {
                String msg = String.format("%s '%s' is not writable.", fileDescription, file.getAbsolutePath());
                operationLog.error((Object)msg);
                throw new EnvironmentFailureException(msg);
            }
        }
        if (!file.canWrite()) {
            String msg = String.format("%s '%s' is not writable.", fileDescription, file.getAbsolutePath());
            operationLog.error((Object)msg);
            throw new EnvironmentFailureException(msg);
        }
    }

    @Override
    public String getId() {
        return this.file.getPath();
    }

    private static List<String> primReadLines(File file) throws IOException {
        return FileUtils.readLines((File)file);
    }

    @Override
    public List<String> readLines() throws ConfigurationFailureException {
        if (!this.file.exists()) {
            return new ArrayList<String>();
        }
        if (!this.file.canRead()) {
            String msg = String.format(this.file.exists() ? "File '%s' cannot be read." : "File '%s' does not exist.", this.file.getAbsolutePath());
            operationLog.error((Object)msg);
            throw new ConfigurationFailureException(msg);
        }
        try {
            List<String> lines = FileBasedLineStore.primReadLines(this.file);
            this.lastReadTimestamp = this.file.lastModified();
            return lines;
        }
        catch (IOException ex) {
            String msg = String.format("Error when reading file '%s'.", this.file.getAbsolutePath());
            machineLog.error((Object)msg, (Throwable)ex);
            throw new EnvironmentFailureException(msg, (Throwable)ex);
        }
    }

    private static void primWriteLines(File file, List<String> lines) {
        if (!file.canWrite()) {
            String msg = String.format(file.exists() ? "File '%s' cannot be written." : "File '%s' does not exist.", file.getAbsolutePath());
            operationLog.error((Object)msg);
            throw new ConfigurationFailureException(msg);
        }
        try {
            FileUtils.writeLines((File)file, lines);
        }
        catch (IOException ex) {
            String msg = String.format("Error when writing file '%s'.", file.getAbsolutePath());
            machineLog.error((Object)msg, (Throwable)ex);
            throw new EnvironmentFailureException(msg, (Throwable)ex);
        }
    }

    private void checkWritable() throws EnvironmentFailureException {
        FileBasedLineStore.checkWritable(this.file, this.fileDescription);
        FileBasedLineStore.checkWritable(this.oldFile, this.fileDescription);
        FileBasedLineStore.checkWritable(this.newFile, this.fileDescription);
    }

    @Override
    public void writeLines(List<String> lines) {
        this.checkWritable();
        FileBasedLineStore.primWriteLines(this.newFile, lines);
        this.oldFile.delete();
        this.file.renameTo(this.oldFile);
        this.newFile.renameTo(this.file);
        this.lastReadTimestamp = this.file.lastModified();
    }

    @Override
    public boolean hasChanged() {
        return this.file.lastModified() != this.lastReadTimestamp;
    }
}

