/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.file.ILineStore;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.authentication.file.UserEntryAuthenticationState;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class LineBasedUserStore<T extends UserEntry>
implements IUserStore<T> {
    private final ILineStore lineStore;
    private final IUserEntryFactory<T> userEntryFactory;
    private Map<String, T> idToEntryMap;
    private Map<String, T> emailToEntryMap;

    LineBasedUserStore(ILineStore lineStore, IUserEntryFactory<T> userEntryFactory) {
        this.lineStore = lineStore;
        this.userEntryFactory = userEntryFactory;
        this.idToEntryMap = new LinkedHashMap<String, T>();
        this.emailToEntryMap = new LinkedHashMap<String, T>();
    }

    private synchronized Map<String, T> getIdToEntryMap() {
        return this.idToEntryMap;
    }

    private synchronized Map<String, T> getEmailToEntryMap() {
        return this.emailToEntryMap;
    }

    synchronized void setEntryMaps(Map<String, T> idToEntryMap, Map<String, T> emailToEntryMap) {
        this.idToEntryMap = idToEntryMap;
        this.emailToEntryMap = emailToEntryMap;
    }

    private void updateMaps() {
        if (this.lineStore.hasChanged()) {
            LinkedHashMap<String, T> newIdToEntryMap = new LinkedHashMap<String, T>();
            LinkedHashMap<String, T> newEmailToEntryMap = new LinkedHashMap<String, T>();
            for (String line : this.lineStore.readLines()) {
                T entry = this.userEntryFactory.create(line);
                newIdToEntryMap.put(((UserEntry)((Object)entry)).getUserId(), entry);
                if (!StringUtils.isNotBlank((String)((UserEntry)((Object)entry)).getEmail()) || newEmailToEntryMap.put(((UserEntry)((Object)entry)).getEmail().toLowerCase(), entry) == null) continue;
                this.emailToEntryMap.remove(((UserEntry)((Object)entry)).getEmail().toLowerCase());
            }
            this.setEntryMaps(newIdToEntryMap, newEmailToEntryMap);
        }
    }

    private List<String> asPasswordLines() {
        Collection<T> users = this.getIdToEntryMap().values();
        ArrayList<String> lines = new ArrayList<String>(users.size());
        for (UserEntry user : users) {
            lines.add(user.asPasswordLine());
        }
        return lines;
    }

    @Override
    public String getId() {
        return this.lineStore.getId();
    }

    @Override
    public T tryGetUserById(String user) {
        this.updateMaps();
        return (T)((Object)((UserEntry)((Object)this.getIdToEntryMap().get(user))));
    }

    @Override
    public T tryGetUserByEmail(String email) throws EnvironmentFailureException {
        this.updateMaps();
        return (T)((Object)((UserEntry)((Object)this.getEmailToEntryMap().get(email.toLowerCase()))));
    }

    @Override
    public UserEntryAuthenticationState<T> tryGetAndAuthenticateUserById(String userId, String password) throws EnvironmentFailureException {
        T entry = this.tryGetUserById(userId);
        if (entry == null) {
            return null;
        }
        boolean authenticated = this.isPasswordCorrect(userId, password);
        return new UserEntryAuthenticationState<T>(entry, authenticated);
    }

    @Override
    public UserEntryAuthenticationState<T> tryGetAndAuthenticateUserByEmail(String email, String password) throws EnvironmentFailureException {
        T entry = this.tryGetUserByEmail(email);
        if (entry == null) {
            return null;
        }
        boolean authenticated = this.isPasswordCorrect(((UserEntry)((Object)entry)).getUserId(), password);
        return new UserEntryAuthenticationState<T>(entry, authenticated);
    }

    @Override
    public synchronized void addOrUpdateUser(T user) {
        assert (user != null);
        this.updateMaps();
        UserEntry oldUserOrNull = (UserEntry)((Object)this.idToEntryMap.put(((UserEntry)((Object)user)).getUserId(), user));
        if (oldUserOrNull != null && StringUtils.isNotBlank((String)oldUserOrNull.getEmail())) {
            this.emailToEntryMap.remove(oldUserOrNull.getEmail().toLowerCase());
        }
        if (StringUtils.isNotBlank((String)((UserEntry)((Object)user)).getEmail()) && this.emailToEntryMap.put(((UserEntry)((Object)user)).getEmail().toLowerCase(), user) != null) {
            this.emailToEntryMap.remove(((UserEntry)((Object)user)).getEmail().toLowerCase());
        }
        this.lineStore.writeLines(this.asPasswordLines());
    }

    @Override
    public synchronized boolean removeUser(String userId) {
        assert (userId != null);
        this.updateMaps();
        UserEntry oldEntryOrNull = (UserEntry)((Object)this.idToEntryMap.remove(userId));
        if (oldEntryOrNull != null) {
            if (StringUtils.isNotBlank((String)oldEntryOrNull.getEmail())) {
                this.emailToEntryMap.remove(oldEntryOrNull.getEmail().toLowerCase());
            }
            this.lineStore.writeLines(this.asPasswordLines());
            return true;
        }
        return false;
    }

    @Override
    public boolean isPasswordCorrect(String user, String password) {
        assert (user != null);
        T userEntryOrNull = this.tryGetUserById(user);
        if (userEntryOrNull == null) {
            return false;
        }
        return ((UserEntry)((Object)userEntryOrNull)).isPasswordCorrect(password);
    }

    @Override
    public List<T> listUsers() {
        this.updateMaps();
        return new ArrayList<T>(this.getIdToEntryMap().values());
    }

    public void check() throws ConfigurationFailureException {
        this.lineStore.check();
    }

    public boolean isRemote() {
        return false;
    }

    static interface IUserEntryFactory<T extends UserEntry> {
        public T create(String var1);
    }
}

