/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import java.util.ArrayList;
import java.util.List;

final class Parameters {
    private final IExitHandler exitHandler;
    private final Command command;
    private final boolean cache;
    private String userId;
    @Option(name="f", longName="first-name", usage="First name of the user.")
    private String firstNameOrNull;
    @Option(name="l", longName="last-name", usage="Last name of the user.")
    private String lastNameOrNull;
    @Option(name="e", longName="email", usage="Email address of the user.")
    private String emailOrNull;
    @Option(name="p", longName="password", usage="The password.")
    private String password;
    @Option(name="P", longName="change-password", usage="Read the new password from the console.")
    private boolean changePassword;
    @Argument
    private List<String> arguments = new ArrayList<String>();
    private final CmdLineParser parser = new CmdLineParser((Object)this);

    @Option(longName="help", skipForExample=true, usage="Prints out a description of the options.")
    void printHelp(boolean exit) {
        if (this.cache) {
            System.err.println("passwd_cache list | [remove|show|test] <user>");
        } else {
            this.parser.printHelp("passwd", "list | [remove|show|test] <user> | [add|change] <user> [option [...]]", "", ExampleMode.NONE);
        }
        if (exit) {
            this.exitHandler.exit(0);
        }
    }

    Parameters(String[] args, boolean cache) {
        this(args, cache, SystemExit.SYSTEM_EXIT);
    }

    Parameters(String[] args, boolean cache, IExitHandler systemExitHandler) {
        this.exitHandler = systemExitHandler;
        this.cache = cache;
        try {
            this.parser.parseArgument(args);
            if (this.arguments.size() < 1 || this.arguments.size() > 2) {
                this.printHelp(true);
            }
            this.command = Parameters.tryGetCommand(this.arguments.get(0));
            if (this.command == null) {
                throw UserFailureException.fromTemplate((String)"Illegal command '%s'", (Object[])new Object[]{this.arguments.get(0)});
            }
            if (Command.LIST.equals((Object)this.command)) {
                if (this.arguments.size() != 1 || this.firstNameOrNull != null || this.lastNameOrNull != null || this.emailOrNull != null || this.password != null) {
                    this.printHelp(true);
                }
            } else {
                if (this.arguments.size() != 2) {
                    this.printHelp(true);
                }
                this.userId = this.arguments.get(1);
                if (!(Command.CHANGE.equals((Object)this.command) || Command.ADD.equals((Object)this.command) || this.firstNameOrNull == null && this.lastNameOrNull == null && this.emailOrNull == null && this.password == null && !this.changePassword)) {
                    this.printHelp(true);
                }
            }
        }
        catch (Exception ex) {
            this.outputException(ex);
            systemExitHandler.exit(1);
            throw new AssertionError((Object)ex.getMessage());
        }
    }

    private void outputException(Exception ex) {
        if (ex instanceof HighLevelException || ex instanceof CmdLineException) {
            System.err.println(ex.getMessage());
        } else {
            System.err.println("An exception occurred.");
            ex.printStackTrace();
        }
        if (ex instanceof CmdLineException) {
            this.printHelp(false);
        }
    }

    private static Command tryGetCommand(String commandString) {
        assert (commandString != null);
        for (Command c : Command.values()) {
            if (!c.getName().equals(commandString)) continue;
            return c;
        }
        return null;
    }

    private static void checkValid(String fieldOrNull, String describer) {
        if (fieldOrNull == null) {
            return;
        }
        if (fieldOrNull.indexOf(58) >= 0) {
            throw new UserFailureException(StringUtilities.capitalize((String)describer) + " '" + fieldOrNull + "' must not contain a ':'.");
        }
    }

    final Command getCommand() {
        return this.command;
    }

    final String getUserId() {
        assert (this.userId != null);
        Parameters.checkValid(this.userId, "user id");
        return this.userId;
    }

    final String getFirstName() {
        Parameters.checkValid(this.firstNameOrNull, "first name");
        return this.firstNameOrNull == null ? "" : this.firstNameOrNull;
    }

    final Boolean isFirstNameSet() {
        return this.firstNameOrNull != null;
    }

    final String getLastName() {
        Parameters.checkValid(this.lastNameOrNull, "last name");
        return this.lastNameOrNull == null ? "" : this.lastNameOrNull;
    }

    final Boolean isLastNameSet() {
        return this.lastNameOrNull != null;
    }

    final String getEmail() {
        Parameters.checkValid(this.emailOrNull, "email");
        return this.emailOrNull == null ? "" : this.emailOrNull;
    }

    final Boolean isEmailSet() {
        return this.emailOrNull != null;
    }

    final boolean isChangePassword() {
        return this.changePassword;
    }

    final String tryGetPassword() {
        return this.password;
    }

    static enum Command {
        ADD("add"),
        REMOVE("remove"),
        CHANGE("change"),
        SHOW("show"),
        LIST("list"),
        TEST("test");

        private final String name;

        private Command(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

