/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.file.CachingAuthenticationService;
import ch.systemsx.cisd.authentication.file.FileAuthenticationService;
import ch.systemsx.cisd.authentication.file.IUserStore;
import ch.systemsx.cisd.authentication.file.Parameters;
import ch.systemsx.cisd.authentication.file.UserCacheEntry;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jline.ConsoleReader;
import org.apache.commons.lang3.StringUtils;

public class PasswordEditorCommand {
    private static final String ENTER_NEW_PASSWORD_MSG = "Enter new password: ";
    private static final String ENTER_PASSWORD_MSG = "Enter the user's password: ";
    private static final File PASSWORD_FILE = new File("etc/passwd");
    private static final boolean isCacheFile = StringUtils.isNotEmpty((CharSequence)System.getProperty("PASSWORD_CACHE_FILE"));
    private static ConsoleReader consoleReader;

    private static final ConsoleReader getConsoleReader() {
        if (consoleReader == null) {
            try {
                consoleReader = new ConsoleReader();
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("ConsoleReader could not be instantiated.", (Throwable)ex);
            }
        }
        return consoleReader;
    }

    private static final String readPassword(String message) {
        try {
            return PasswordEditorCommand.getConsoleReader().readLine(message, Character.valueOf('*'));
        }
        catch (IOException ex) {
            System.err.println("Error reading password (" + ex.getMessage() + ").");
            System.exit(1);
            return null;
        }
    }

    private static File getPasswordFile() {
        if (isCacheFile) {
            return new File(System.getProperty("PASSWORD_CACHE_FILE"));
        }
        if (System.getProperty("PASSWORD_FILE") != null) {
            return new File(System.getProperty("PASSWORD_FILE"));
        }
        return PASSWORD_FILE;
    }

    private static void printUser(UserEntry user) {
        System.out.printf("%-20s  %-20s  %-20s  %-20s\n", user.getUserId(), user.getFirstName(), user.getLastName(), user.getEmail());
    }

    private static void printUserCache(UserCacheEntry user) {
        System.out.printf("%-20s  %-20s  %-20s  %-30s  %-20s\n", user.getUserId(), user.getFirstName(), user.getLastName(), user.getEmail(), ((SimpleDateFormat)DateFormatThreadLocal.DATE_FORMAT.get()).format(new Date(user.getCachedAt())));
    }

    private static void printHeader() {
        System.out.printf("%-20s  %-20s  %-20s  %-20s\n", "User ID", "First Name", "Last Name", "Email");
    }

    private static void printHeaderCache() {
        System.out.printf("%-20s  %-20s  %-20s  %-30s  %-20s\n", "User ID", "First Name", "Last Name", "Email", "Cached At");
    }

    private static void execute(Parameters params) {
        IUserStore<UserEntry> userStore = FileAuthenticationService.createUserStore(PasswordEditorCommand.getPasswordFile());
        switch (params.getCommand()) {
            case ADD: {
                String userId = params.getUserId();
                UserEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull != null) {
                    System.err.printf("User '%s' already exists.\n", userId);
                    System.exit(1);
                }
                String password = params.tryGetPassword() != null ? params.tryGetPassword() : PasswordEditorCommand.readPassword(ENTER_NEW_PASSWORD_MSG);
                UserEntry user = new UserEntry(params.getUserId(), params.getEmail(), params.getFirstName(), params.getLastName(), password);
                userStore.addOrUpdateUser(user);
                break;
            }
            case CHANGE: {
                String userId = params.getUserId();
                UserEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull == null) {
                    System.err.printf("User '%s' does not exist.\n", userId);
                    System.exit(1);
                    return;
                }
                PasswordEditorCommand.applyParamsToExistingUser(params, userOrNull);
                userStore.addOrUpdateUser(userOrNull);
                break;
            }
            case LIST: {
                PasswordEditorCommand.printHeader();
                for (UserEntry user : userStore.listUsers()) {
                    PasswordEditorCommand.printUser(user);
                }
                break;
            }
            case REMOVE: {
                String userId = params.getUserId();
                if (userStore.removeUser(userId)) break;
                System.err.printf("User '%s' does not exist.\n", userId);
                System.exit(1);
                break;
            }
            case SHOW: {
                String userId = params.getUserId();
                UserEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull == null) {
                    System.err.printf("User '%s' does not exist.\n", userId);
                    System.exit(1);
                    return;
                }
                PasswordEditorCommand.printHeader();
                PasswordEditorCommand.printUser(userOrNull);
                break;
            }
            case TEST: {
                String userId = params.getUserId();
                UserEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull == null) {
                    System.err.printf("User '%s' does not exist.\n", userId);
                    System.exit(1);
                    return;
                }
                String password = PasswordEditorCommand.readPassword(ENTER_PASSWORD_MSG);
                if (userStore.isPasswordCorrect(userId, password)) {
                    System.out.printf("User '%s' successfully authenticated.\n", userId);
                    break;
                }
                System.out.printf("User '%s' authentication failed.\n", userId);
                break;
            }
        }
    }

    protected static void applyParamsToExistingUser(Parameters params, UserEntry user) {
        if (params.isFirstNameSet().booleanValue()) {
            user.setFirstName(params.getFirstName());
        }
        if (params.isLastNameSet().booleanValue()) {
            user.setLastName(params.getLastName());
        }
        if (params.isEmailSet().booleanValue()) {
            user.setEmail(params.getEmail());
        }
        if (params.tryGetPassword() != null) {
            user.setPassword(params.tryGetPassword());
        } else if (params.isChangePassword()) {
            user.setPassword(PasswordEditorCommand.readPassword(ENTER_NEW_PASSWORD_MSG));
        }
    }

    private static void executeCache(Parameters params) {
        IUserStore<UserCacheEntry> userStore = CachingAuthenticationService.createUserStore(PasswordEditorCommand.getPasswordFile());
        switch (params.getCommand()) {
            case ADD: 
            case CHANGE: {
                System.err.println((Object)((Object)params.getCommand()) + " not supported on password cache files.");
                System.exit(1);
                break;
            }
            case LIST: {
                PasswordEditorCommand.printHeaderCache();
                for (UserCacheEntry user : userStore.listUsers()) {
                    PasswordEditorCommand.printUserCache(user);
                }
                break;
            }
            case REMOVE: {
                String userId = params.getUserId();
                if (userStore.removeUser(userId)) break;
                System.err.printf("User '%s' does not exist.\n", userId);
                System.exit(1);
                break;
            }
            case SHOW: {
                String userId = params.getUserId();
                UserCacheEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull == null) {
                    System.err.printf("User '%s' does not exist.\n", userId);
                    System.exit(1);
                    return;
                }
                PasswordEditorCommand.printHeader();
                PasswordEditorCommand.printUserCache(userOrNull);
                break;
            }
            case TEST: {
                String userId = params.getUserId();
                UserCacheEntry userOrNull = userStore.tryGetUserById(userId);
                if (userOrNull == null) {
                    System.err.printf("User '%s' does not exist.\n", userId);
                    System.exit(1);
                    return;
                }
                String password = PasswordEditorCommand.readPassword(ENTER_PASSWORD_MSG);
                if (userStore.isPasswordCorrect(userId, password)) {
                    System.out.printf("User '%s' successfully authenticated.\n", userId);
                    break;
                }
                System.out.printf("User '%s' authentication failed.\n", userId);
                break;
            }
        }
    }

    public static void main(String[] args) {
        try {
            Parameters params = new Parameters(args, isCacheFile);
            if (isCacheFile) {
                PasswordEditorCommand.executeCache(params);
            } else {
                PasswordEditorCommand.execute(params);
            }
        }
        catch (HighLevelException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }
}

