/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.file.UserEntry;
import ch.systemsx.cisd.common.security.PasswordHasher;
import org.apache.commons.lang3.StringUtils;

public class UserCacheEntry
extends UserEntry {
    static final int NUMBER_OF_COLUMNS_IN_PASSWORD_CACHE_FILE = 6;
    private static final int CACHED_AT_IDX = 5;
    private final long cachedAt;

    UserCacheEntry(String passwordFileLine) throws IllegalArgumentException {
        super(UserCacheEntry.split(passwordFileLine, 6));
        this.cachedAt = Long.parseLong(this.getElement(5));
    }

    UserCacheEntry(Principal p, long cachedAt) {
        this(p, null, cachedAt);
    }

    UserCacheEntry(Principal p, String passwordOrNull, long cachedAt) {
        super(UserCacheEntry.createPasswordFileEntry(p, passwordOrNull, cachedAt));
        this.cachedAt = cachedAt;
    }

    private static String[] createPasswordFileEntry(Principal p, String passwordOrNull, long cachedAt) {
        assert (p != null);
        return new String[]{p.getUserId(), p.getEmail(), p.getFirstName(), p.getLastName(), p.isAuthenticated() && StringUtils.isNotEmpty((CharSequence)passwordOrNull) ? PasswordHasher.computeSaltedHash((String)passwordOrNull) : "", Long.toString(cachedAt)};
    }

    long getCachedAt() {
        return this.cachedAt;
    }

    @Override
    void setEmail(String email) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    void setFirstName(String firstName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    void setLastName(String lastName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    void setPassword(String plainPassword) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

