/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.common.security.PasswordHasher;
import org.apache.commons.lang3.StringUtils;

class UserEntry
extends AbstractHashable {
    private static final int NUMBER_OF_COLUMNS_IN_PASSWORD_FILE = 5;
    private static final int USER_ID_IDX = 0;
    private static final int EMAIL_IDX = 1;
    private static final int FIRST_NAME_IDX = 2;
    private static final int LAST_NAME_IDX = 3;
    private static final int PASSWORD_IDX = 4;
    private final String[] passwordFileEntry;

    UserEntry(String passwordFileLine) throws IllegalArgumentException {
        this.passwordFileEntry = UserEntry.split(passwordFileLine, 5);
    }

    static String[] split(String passwordFileLine, int numberOfColumnsInPasswdFile) throws IllegalArgumentException {
        assert (passwordFileLine != null);
        String[] entry = StringUtils.splitPreserveAllTokens((String)passwordFileLine, (char)':');
        if (entry.length != numberOfColumnsInPasswdFile) {
            String msg = String.format("Password line is ill-formatted: '%s'", passwordFileLine);
            throw new IllegalArgumentException(msg);
        }
        return entry;
    }

    UserEntry(String[] passwordFileEntry) throws IllegalArgumentException {
        this.passwordFileEntry = passwordFileEntry;
    }

    UserEntry(String userId, String email, String firstName, String lastName, String password) {
        assert (userId != null);
        assert (email != null);
        assert (firstName != null);
        assert (lastName != null);
        assert (password != null);
        this.passwordFileEntry = new String[]{userId, email, firstName, lastName, StringUtils.isEmpty((CharSequence)password) ? "" : PasswordHasher.computeSaltedHash((String)password)};
    }

    synchronized String asPasswordLine() {
        return StringUtils.join((Object[])this.passwordFileEntry, (char)':');
    }

    synchronized Principal asPrincipal() {
        return new Principal(this.getUserId(), this.getFirstName(), this.getLastName(), this.getEmail(), false);
    }

    synchronized String getElement(int idx) {
        return this.passwordFileEntry[idx];
    }

    synchronized String getUserId() {
        return this.passwordFileEntry[0];
    }

    synchronized String getEmail() {
        return this.passwordFileEntry[1];
    }

    synchronized void setEmail(String email) {
        assert (email != null);
        this.passwordFileEntry[1] = email;
    }

    synchronized String getFirstName() {
        return this.passwordFileEntry[2];
    }

    synchronized void setFirstName(String firstName) {
        assert (firstName != null);
        this.passwordFileEntry[2] = firstName;
    }

    synchronized String getLastName() {
        return this.passwordFileEntry[3];
    }

    synchronized void setLastName(String lastName) {
        assert (lastName != null);
        this.passwordFileEntry[3] = lastName;
    }

    synchronized String getPasswordHash() {
        return this.passwordFileEntry[4];
    }

    synchronized void setPassword(String plainPassword) {
        this.passwordFileEntry[4] = StringUtils.isBlank((CharSequence)plainPassword) ? "" : PasswordHasher.computeSaltedHash((String)plainPassword);
    }

    synchronized boolean hasPassword() {
        return StringUtils.isNotBlank((CharSequence)this.getPasswordHash());
    }

    synchronized boolean isPasswordCorrect(String passwordOrNull) {
        String hash = this.getPasswordHash();
        return StringUtils.isEmpty((CharSequence)passwordOrNull) || StringUtils.isBlank((CharSequence)hash) ? false : PasswordHasher.isPasswordCorrect((String)passwordOrNull, (String)hash);
    }
}

