/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.ldap;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.ldap.LDAPDirectoryConfiguration;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.concurrent.ParallelizedExecutor;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public final class LDAPPrincipalQuery
implements ISelfTestable {
    private static final String DISTINGUISHED_NAME_ATTRIBUTE_NAME = "distinguishedName";
    private static final String UID_NUMBER_ATTRIBUTE_NAME = "uidNumber";
    private static final String LOGIN_DN_MSG_TEMPLATE = "User '%s' <DN='%s'>: authentication %s";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, LDAPPrincipalQuery.class);
    private static final String LDAP_CONTEXT_FACTORY_CLASSNAME = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_CONTEXT_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String LDAP_CONTEXT_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String AUTHENTICATION_FAILURE_TEMPLATE = "Authentication failure connecting to LDAP server '%s'.";
    private static final String LDAP_ERROR_TEMPLATE = "Error connecting to LDAP server '%s'.";
    private final LDAPDirectoryConfiguration config;
    private final ThreadLocal<DirContext> contextHolder;

    public LDAPPrincipalQuery(LDAPDirectoryConfiguration config) {
        this.config = config;
        this.contextHolder = new ThreadLocal();
    }

    public Principal tryGetPrincipal(String userId) throws IllegalArgumentException {
        List<Principal> principals = this.listPrincipalsByUserId(userId, 1);
        return this.tryGetPrincipal(principals, "User '%s' is not unique.", userId);
    }

    public Principal tryGetPrincipalByEmail(String email) {
        List<Principal> principals = this.listPrincipalsByEmail(email, 1);
        return this.tryGetPrincipal(principals, "Email '%s' is not unique.", email);
    }

    private Principal tryGetPrincipal(List<Principal> principals, String msgTemplate, String user) {
        if (principals.size() == 0) {
            return null;
        }
        if (principals.size() == 1) {
            return principals.get(0);
        }
        throw new IllegalArgumentException(String.format(msgTemplate, user));
    }

    public List<Principal> listPrincipalsByUserId(String userId) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByUserId(%s)", userId));
        }
        return this.listPrincipalsByKeyValue(this.config.getUserIdAttributeName(), userId, null, Integer.MAX_VALUE);
    }

    private List<Principal> listPrincipalsByUserId(String userId, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByUserId(%s,%s)", userId, limit));
        }
        return this.listPrincipalsByKeyValue(this.config.getUserIdAttributeName(), userId, null, limit);
    }

    public List<Principal> listPrincipalsByEmail(String email, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByEmail(%s,%s)", email, limit));
        }
        return this.listPrincipalsByKeyValue(this.getEmailAttributeForQueries(), this.getEmailKeyForQueries(email), null, limit);
    }

    private String getEmailAttributeForQueries() {
        if (Boolean.parseBoolean(this.config.getQueryEmailForAliases())) {
            return this.config.getEmailAliasesAttributeName();
        }
        return this.config.getEmailAttributeName();
    }

    private String getEmailKeyForQueries(String emailQuery) {
        if (Boolean.parseBoolean(this.config.getQueryEmailForAliases())) {
            return this.config.getEmailAttributePrefix() + emailQuery;
        }
        return emailQuery;
    }

    public List<Principal> listPrincipalsByEmail(String email) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByEmail(%s)", email));
        }
        return this.listPrincipalsByKeyValue(this.getEmailAttributeForQueries(), this.getEmailKeyForQueries(email), null, Integer.MAX_VALUE);
    }

    public List<Principal> listPrincipalsByLastName(String lastName, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByLastName(%s,%s)", lastName, limit));
        }
        return this.listPrincipalsByKeyValue(this.config.getLastNameAttributeName(), lastName, null, limit);
    }

    public List<Principal> listPrincipalsByLastName(String lastName) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("listPrincipalsByLastName(%s)", lastName));
        }
        return this.listPrincipalsByKeyValue(this.config.getLastNameAttributeName(), lastName, null, Integer.MAX_VALUE);
    }

    public boolean authenticateUser(String userId, String password) {
        Principal principal = this.tryGetAndAuthenticatePrincipal(userId, password);
        return principal == null ? false : principal.isAuthenticated();
    }

    public Principal tryGetAndAuthenticatePrincipal(String userId, String passwordOrNull) {
        Principal principal = this.tryGetPrincipal(userId);
        if (principal == null) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("User '%s' not found in LDAP directory.", userId));
            }
            return null;
        }
        this.authenticatePrincipal(principal, passwordOrNull);
        return principal;
    }

    public Principal tryGetAndAuthenticatePrincipalByEmail(String email, String passwordOrNull) {
        Principal principal = this.tryGetPrincipalByEmail(email);
        if (principal == null) {
            return null;
        }
        this.authenticatePrincipal(principal, passwordOrNull);
        return principal;
    }

    private void authenticatePrincipal(Principal principal, String passwordOrNull) {
        String distinguishedName = principal.getProperty(DISTINGUISHED_NAME_ATTRIBUTE_NAME);
        boolean authenticated = passwordOrNull == null ? false : this.authenticateUserByDistinguishedName(distinguishedName, passwordOrNull);
        principal.setAuthenticated(authenticated);
        if (operationLog.isDebugEnabled() && passwordOrNull != null) {
            operationLog.debug((Object)String.format(LOGIN_DN_MSG_TEMPLATE, principal.getUserId(), distinguishedName, this.getStatus(authenticated)));
        }
    }

    private String getStatus(boolean status) {
        return status ? "OK" : "FAILURE";
    }

    private boolean authenticateUserByDistinguishedName(String dn, String password) {
        try {
            this.createContextForDistinguishedName(dn, password, false, true);
            return true;
        }
        catch (InvalidAuthenticationException ex) {
            return false;
        }
        catch (RuntimeException ex) {
            operationLog.error((Object)String.format("Error on creating context to authenticate dn=<%s>: %s", dn, ex));
            throw ex;
        }
    }

    public List<Principal> listPrincipalsByKeyValueOrQuery(String keyOrNull, String valueOrNull, String queryOrNull) {
        return this.listPrincipalsByKeyValueOrQuery(keyOrNull, valueOrNull, queryOrNull, null, Integer.MAX_VALUE);
    }

    public List<Principal> listPrincipalsByKeyValue(String keyOrNull, String valueOrNull, Collection<String> additionalAttributesOrNull, int limit) {
        return this.listPrincipalsByKeyValueOrQuery(keyOrNull, valueOrNull, null, additionalAttributesOrNull, limit);
    }

    private List<Principal> listPrincipalsByKeyValueOrQuery(String keyOrNull, String valueOrNull, String queryOrNull, Collection<String> additionalAttributesOrNull, int limit) {
        String query = queryOrNull != null ? queryOrNull : String.format(this.config.getQueryTemplate(), String.format("%s=%s", keyOrNull, valueOrNull));
        RuntimeException firstException = null;
        for (int i = 0; i <= this.config.getMaxRetries(); ++i) {
            try {
                return this.primListPrinciplasByQuery(this.config.getSearchBase(), query, additionalAttributesOrNull, limit);
            }
            catch (RuntimeException ex) {
                this.contextHolder.set(null);
                if (firstException == null) {
                    firstException = ex;
                    if (operationLog.isDebugEnabled() && i < this.config.getMaxRetries()) {
                        operationLog.debug((Object)String.format("Error listing principle by query '%s', retrying...", query), (Throwable)ex);
                    }
                }
                if (i >= this.config.getMaxRetries()) continue;
                ConcurrencyUtilities.sleep((long)this.config.getTimeToWaitAfterFailure());
                continue;
            }
        }
        operationLog.error((Object)String.format("Error on LDAP query '%s'", query), (Throwable)firstException);
        throw firstException;
    }

    private List<Principal> primListPrinciplasByQuery(String searchBase, String query, Collection<String> additionalAttributesOrNull, int limit) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        try {
            DirContext context = this.createContext(false);
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            NamingEnumeration<SearchResult> enumeration = context.search(searchBase, query, ctrl);
            int count = 0;
            while (count++ < limit && enumeration.hasMore()) {
                SearchResult result = enumeration.next();
                Attributes attributes = result.getAttributes();
                String userId = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getUserIdAttributeName());
                String email = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getEmailAttributeName());
                String distinguishedName = result.getNameInNamespace();
                if (userId == null || email == null || distinguishedName == null) continue;
                String firstName = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getFirstNameAttributeName(), "?");
                String lastName = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getLastNameAttributeName(), "?");
                String uidNumber = LDAPPrincipalQuery.tryGetAttribute(attributes, UID_NUMBER_ATTRIBUTE_NAME);
                Principal principal = new Principal(userId, firstName, lastName, email, false);
                principal.getProperties().put(DISTINGUISHED_NAME_ATTRIBUTE_NAME, distinguishedName);
                if (uidNumber != null) {
                    principal.getProperties().put(UID_NUMBER_ATTRIBUTE_NAME, uidNumber);
                }
                if (additionalAttributesOrNull != null) {
                    if (additionalAttributesOrNull.isEmpty()) {
                        principal.setProperties(LDAPPrincipalQuery.getAllAttributes(attributes));
                    } else {
                        for (String attributeName : additionalAttributesOrNull) {
                            String attributeValue = LDAPPrincipalQuery.tryGetAttribute(attributes, attributeName);
                            if (attributeValue == null) continue;
                            principal.getProperties().put(attributeName, attributeValue);
                        }
                    }
                }
                principals.add(principal);
            }
            return principals;
        }
        catch (AuthenticationException ex) {
            throw ConfigurationFailureException.fromTemplate((Throwable)ex, (String)AUTHENTICATION_FAILURE_TEMPLATE, (Object[])new Object[]{this.config.getServerUrl()});
        }
        catch (NamingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private DirContext createContext(boolean retry) {
        return this.createContextForDistinguishedName(this.config.getSecurityPrincipalDistinguishedName(), this.config.getSecurityPrincipalPassword(), true, retry);
    }

    private DirContext createContextForDistinguishedName(String dn, String password, boolean useThreadContext, boolean retry) {
        DirContext threadContext;
        DirContext dirContext = threadContext = useThreadContext ? this.contextHolder.get() : null;
        if (threadContext != null) {
            return threadContext;
        }
        if (password != null && password.isEmpty()) {
            throw new RuntimeException("Try to login user '" + dn + "' with empty password.");
        }
        String serverUrl = this.config.getServerUrl();
        String[] urls = serverUrl.split(" ");
        ResultHolder<DirContext> resultHolder = new ResultHolder<DirContext>();
        Set<Thread> workerThreads = Collections.synchronizedSet(new HashSet());
        ITaskExecutor<String> taskExecutor = this.createTask(dn, password, resultHolder, workerThreads);
        Collection failures = ParallelizedExecutor.process(Arrays.asList(urls), taskExecutor, (double)0.5, (int)urls.length, (String)"ldap query", (int)this.config.getMaxRetries(), (boolean)false);
        DirContext dirContext2 = resultHolder.getResult();
        if (dirContext2 == null) {
            if (!failures.isEmpty()) {
                String failureReport = ParallelizedExecutor.tryFailuresToString((Collection)failures);
                throw new InvalidAuthenticationException("Failed to create an LDAP dir context: " + failureReport);
            }
            throw new InvalidAuthenticationException("Failed to create an LDAP dir context: no failure report");
        }
        if (useThreadContext) {
            this.contextHolder.set(dirContext2);
        }
        return dirContext2;
    }

    private ITaskExecutor<String> createTask(final String dn, final String password, final ResultHolder<DirContext> resultHolder, final Set<Thread> workerThreads) {
        final Thread masterThread = Thread.currentThread();
        return new ITaskExecutor<String>(){
            private ThreadLocal<AtomicInteger> numberOfTries = new ThreadLocal();

            public Status execute(String url) {
                workerThreads.add(Thread.currentThread());
                if (resultHolder.hasResult()) {
                    return Status.OK;
                }
                this.getNumberOfTries().getAndIncrement();
                Hashtable<String, String> env = this.createEnvironment(url, dn, password);
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug((Object)String.format("Try to login to %s with dn=%s", LDAPPrincipalQuery.this.config.getServerUrl(), dn));
                }
                try {
                    resultHolder.setResult(new InitialDirContext(env));
                    this.interruptWorkers(workerThreads, masterThread);
                    operationLog.info((Object)("Dir context successfully created with LDAP server '" + url + "'."));
                    return Status.OK;
                }
                catch (Exception ex) {
                    if (resultHolder.hasResult()) {
                        return Status.OK;
                    }
                    if (ex instanceof AuthenticationException) {
                        String message = "Failed to authenticate dn=<" + dn + "> at LDAP service '" + url + "'.";
                        operationLog.debug((Object)message, (Throwable)ex);
                        return Status.createError((String)message);
                    }
                    String message = "Error connecting to LDAP service '" + url + "': cannot open a context for dn=<" + dn + ">";
                    if (this.getNumberOfTries().get() <= LDAPPrincipalQuery.this.config.getMaxRetries()) {
                        operationLog.debug((Object)message, (Throwable)ex);
                        ConcurrencyUtilities.sleep((long)LDAPPrincipalQuery.this.config.getTimeToWaitAfterFailure());
                    } else {
                        operationLog.error((Object)message, (Throwable)ex);
                    }
                    return Status.createRetriableError((String)message);
                }
            }

            private Hashtable<String, String> createEnvironment(String url, String dn2, String password2) {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", LDAPPrincipalQuery.LDAP_CONTEXT_FACTORY_CLASSNAME);
                env.put("java.naming.provider.url", url);
                env.put("java.naming.security.protocol", LDAPPrincipalQuery.this.config.getSecurityProtocol());
                env.put("java.naming.security.authentication", LDAPPrincipalQuery.this.config.getSecurityAuthenticationMethod());
                env.put("java.naming.referral", LDAPPrincipalQuery.this.config.getReferral());
                env.put("java.naming.security.principal", dn2);
                env.put("java.naming.security.credentials", password2);
                env.put(LDAPPrincipalQuery.LDAP_CONTEXT_READ_TIMEOUT, Long.toString(LDAPPrincipalQuery.this.config.getTimeout()));
                env.put(LDAPPrincipalQuery.LDAP_CONTEXT_CONNECT_TIMEOUT, Long.toString(LDAPPrincipalQuery.this.config.getTimeout()));
                return env;
            }

            private AtomicInteger getNumberOfTries() {
                AtomicInteger result = this.numberOfTries.get();
                if (result == null) {
                    result = new AtomicInteger();
                    this.numberOfTries.set(result);
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void interruptWorkers(Set<Thread> workerThreads2, Thread masterThread2) {
                Set<Thread> set = workerThreads2;
                synchronized (set) {
                    for (Thread thread : workerThreads2) {
                        if (thread == masterThread2) continue;
                        thread.interrupt();
                    }
                }
            }
        };
    }

    private static String tryGetAttribute(Attributes attributes, String attributeName) throws NamingException {
        return LDAPPrincipalQuery.tryGetAttribute(attributes, attributeName, null);
    }

    private static String tryGetAttribute(Attributes attributes, String attributeName, String defaultValue) throws NamingException {
        BasicAttribute basicAttribute = (BasicAttribute)attributes.get(attributeName);
        if (basicAttribute == null) {
            return defaultValue;
        }
        NamingEnumeration<?> values = basicAttribute.getAll();
        StringBuilder builder = new StringBuilder();
        while (values.hasMore()) {
            builder.append(values.next().toString());
            builder.append("::");
        }
        if (builder.length() == 0) {
            return defaultValue;
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    private static Map<String, String> getAllAttributes(Attributes attributes) throws NamingException {
        HashMap<String, String> result = new HashMap<String, String>();
        NamingEnumeration<? extends Attribute> attributeEnum = attributes.getAll();
        if (attributeEnum == null) {
            return result;
        }
        while (attributeEnum.hasMore()) {
            BasicAttribute attribute = (BasicAttribute)attributeEnum.next();
            String attributeName = attribute.getID();
            NamingEnumeration<?> values = attribute.getAll();
            StringBuilder builder = new StringBuilder();
            while (values.hasMore()) {
                builder.append(values.next().toString());
                builder.append("::");
            }
            if (builder.length() <= 2) continue;
            builder.setLength(builder.length() - 2);
            result.put(attributeName, builder.toString());
        }
        return result;
    }

    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        try {
            this.createContext(true);
        }
        catch (InvalidAuthenticationException ex) {
            throw ConfigurationFailureException.fromTemplate((Throwable)ex, (String)AUTHENTICATION_FAILURE_TEMPLATE, (Object[])new Object[]{this.config.getServerUrl()});
        }
        catch (RuntimeException ex) {
            throw EnvironmentFailureException.fromTemplate((Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex), (String)LDAP_ERROR_TEMPLATE, (Object[])new Object[]{this.config.getServerUrl()});
        }
    }

    public boolean isRemote() {
        return !this.config.getServerUrl().contains("localhost") && !this.config.getServerUrl().contains("127.0.0.1");
    }

    private static final class ResultHolder<T> {
        private T result;

        private ResultHolder() {
        }

        public T getResult() {
            return this.result;
        }

        public synchronized boolean hasResult() {
            return this.result != null;
        }

        public synchronized void setResult(T result) {
            this.result = result;
        }
    }
}

