/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.yeastx.db.DBUtils;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public abstract class AbstractEICMLDatastoreReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;
    private final String dataSourceName;

    protected abstract TableModel createReport(List<DatasetDescription> var1, IEICMSRunDAO var2);

    public AbstractEICMLDatastoreReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.dataSourceName = DataSourceProvider.extractDataSourceName((Properties)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource(this.dataSourceName);
        try (IEICMSRunDAO query = DBUtils.getQuery(dataSource, IEICMSRunDAO.class);){
            TableModel tableModel = this.createReport(datasets, query);
            return tableModel;
        }
    }
}

