/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GeneratedImageTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import ch.systemsx.cisd.yeastx.eicml.AbstractEICMLDatastoreReportingPlugin;
import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import net.lemnik.eodsql.DataIterator;

public class EICMLChromatogramImagesReporter
extends AbstractEICMLDatastoreReportingPlugin {
    public static final String CHROMATOGRAM_CODE_PARAM = "chromatogram";
    public static final String DATASET_CODE_PARAM = "dataset";
    private static final String CHROMATOGRAM_SERVLET = "chromatogram";
    private static final int MZ_1_COLUMN_INDEX = 1;
    private static final int THUMBNAIL_WIDTH = 300;
    private static final int THUMBNAIL_HEIGHT = 150;
    private static final int IMAGE_WIDTH = 1066;
    private static final int IMAGE_HEIGHT = 600;
    private static final long serialVersionUID = 1L;

    public EICMLChromatogramImagesReporter(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    protected final TableModel createReport(List<DatasetDescription> datasets, IEICMSRunDAO query) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        EICMLChromatogramImagesReporter.addReportHeaders(builder);
        List<DatasetRun> runs = this.fetchRuns(datasets, query);
        for (DatasetRun datasetRun : runs) {
            DataIterator<ChromatogramDTO> chromatograms = query.getChromatogramsForRun(datasetRun.getRun());
            datasetRun.setChromatograms(chromatograms);
            EICMLChromatogramImagesReporter.addRun(builder, datasetRun);
        }
        TableModel tableModel = builder.getTableModel();
        List rows = tableModel.getRows();
        Collections.sort(rows, new Comparator<TableModelRow>(){

            @Override
            public int compare(TableModelRow r1, TableModelRow r2) {
                ISerializableComparable v1 = (ISerializableComparable)r1.getValues().get(1);
                ISerializableComparable v2 = (ISerializableComparable)r2.getValues().get(1);
                return v1.compareTo((Object)v2);
            }
        });
        return tableModel;
    }

    private List<DatasetRun> fetchRuns(List<DatasetDescription> datasets, IEICMSRunDAO query) {
        ArrayList<DatasetRun> runs = new ArrayList<DatasetRun>();
        for (DatasetDescription dataset : datasets) {
            EICMSRunDTO run = query.getMSRunByDatasetPermId(dataset.getDataSetCode());
            if (run == null) continue;
            runs.add(new DatasetRun(dataset.getDataSetCode(), run));
        }
        return runs;
    }

    private static void addRun(SimpleTableModelBuilder builder, DatasetRun datasetRun) {
        String datasetCode = datasetRun.getDatasetCode();
        EICMSRunDTO run = datasetRun.getRun();
        DataIterator<ChromatogramDTO> chromatograms = datasetRun.getChromatograms();
        for (ChromatogramDTO chromatogram : chromatograms) {
            builder.addRow(EICMLChromatogramImagesReporter.createRow(builder, datasetCode, run, chromatogram));
        }
    }

    private static List<ISerializableComparable> createRow(SimpleTableModelBuilder builder, String datasetCode, EICMSRunDTO run, ChromatogramDTO chromatogram) {
        ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
        GeneratedImageTableCell imageCell = new GeneratedImageTableCell("datastore_server/chromatogram", 1066, 600, 300, 150);
        imageCell.addParameter(DATASET_CODE_PARAM, (Object)datasetCode);
        imageCell.addParameter("chromatogram", (Object)chromatogram.getId());
        String chromatogramLabel = chromatogram.getLabel();
        row.add(SimpleTableModelBuilder.asText((String)chromatogramLabel));
        int mz1 = Math.round(chromatogram.getQ1Mz());
        row.add(SimpleTableModelBuilder.asInteger((long)mz1));
        int mz2 = Math.round(chromatogram.getQ3LowMz());
        row.add(SimpleTableModelBuilder.asInteger((long)mz2));
        row.add((ISerializableComparable)imageCell);
        return row;
    }

    private static void addReportHeaders(SimpleTableModelBuilder builder) {
        builder.addHeader("Label", 100);
        builder.addHeader("m/z 1", 50);
        builder.addHeader("m/z 2", 50);
        builder.addHeader("Chromatogram", 300);
    }

    private static class DatasetRun {
        private final String datasetCode;
        private final EICMSRunDTO run;
        DataIterator<ChromatogramDTO> chromatograms;

        public DatasetRun(String datasetCode, EICMSRunDTO run) {
            this.datasetCode = datasetCode;
            this.run = run;
        }

        String getDatasetCode() {
            return this.datasetCode;
        }

        EICMSRunDTO getRun() {
            return this.run;
        }

        DataIterator<ChromatogramDTO> getChromatograms() {
            return this.chromatograms;
        }

        void setChromatograms(DataIterator<ChromatogramDTO> chromatograms) {
            this.chromatograms = chromatograms;
        }
    }
}

