/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import ch.systemsx.cisd.yeastx.eicml.AbstractEICMLDatastoreReportingPlugin;
import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.lemnik.eodsql.DataIterator;

public class EICMLChromatogramsReporter
extends AbstractEICMLDatastoreReportingPlugin {
    private static final long serialVersionUID = 1L;

    public EICMLChromatogramsReporter(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    protected final TableModel createReport(List<DatasetDescription> datasets, IEICMSRunDAO query) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        EICMLChromatogramsReporter.addReportHeaders(builder);
        List<EICMSRunDTO> runs = this.fetchRuns(datasets, query);
        for (EICMSRunDTO run : runs) {
            DataIterator<ChromatogramDTO> chromatograms = query.getChromatogramsForRun(run);
            EICMLChromatogramsReporter.addRun(builder, run, chromatograms);
        }
        return builder.getTableModel();
    }

    private List<EICMSRunDTO> fetchRuns(List<DatasetDescription> datasets, IEICMSRunDAO query) {
        ArrayList<EICMSRunDTO> runs = new ArrayList<EICMSRunDTO>();
        for (DatasetDescription dataset : datasets) {
            EICMSRunDTO run = query.getMSRunByDatasetPermId(dataset.getDataSetCode());
            if (run == null) continue;
            runs.add(run);
        }
        return runs;
    }

    private static void addRun(SimpleTableModelBuilder builder, EICMSRunDTO run, DataIterator<ChromatogramDTO> chromatograms) {
        for (ChromatogramDTO chromatogram : chromatograms) {
            builder.addRow(EICMLChromatogramsReporter.createRow(builder, run, chromatogram));
        }
    }

    private static List<ISerializableComparable> createRow(SimpleTableModelBuilder builder, EICMSRunDTO run, ChromatogramDTO chromatogram) {
        ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
        row.add(SimpleTableModelBuilder.asText((String)chromatogram.getLabel()));
        row.add(SimpleTableModelBuilder.asDouble((double)EICMLChromatogramsReporter.calcMin(chromatogram.getRunTimes())));
        row.add(SimpleTableModelBuilder.asDouble((double)EICMLChromatogramsReporter.calcMax(chromatogram.getRunTimes())));
        row.add(SimpleTableModelBuilder.asDouble((double)EICMLChromatogramsReporter.calcMax(chromatogram.getIntensities())));
        row.add(SimpleTableModelBuilder.asDouble((double)chromatogram.getQ1Mz()));
        row.add(SimpleTableModelBuilder.asDouble((double)chromatogram.getQ3LowMz()));
        row.add(SimpleTableModelBuilder.asDouble((double)chromatogram.getQ3HighMz()));
        row.add(SimpleTableModelBuilder.asText((String)("" + chromatogram.getPolarity())));
        return row;
    }

    private static float calcMax(float[] values) {
        if (values.length == 0) {
            return -1.0f;
        }
        float max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    private static float calcMin(float[] values) {
        if (values.length == 0) {
            return -1.0f;
        }
        float min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private static void addReportHeaders(SimpleTableModelBuilder builder) {
        builder.addHeader("Label");
        builder.addHeader("RT Start");
        builder.addHeader("RT End");
        builder.addHeader("Max. Intensity");
        builder.addHeader("Q1 Mz");
        builder.addHeader("Q3Low Mz");
        builder.addHeader("Q3High Mz");
        builder.addHeader("Polarity");
    }
}

