/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EICMLParser
extends DefaultHandler {
    private static final String MS_RUN = "msRun";
    private static final ThreadLocal<DateFormat> dateFormatHolder = new ThreadLocal();
    private StringBuilder buffer = new StringBuilder();
    private EICMSRunDTO msRun;
    private ChromatogramDTO chromatogram;
    private boolean parsingMsRun;
    private boolean parsingChromatogram;
    private final IMSRunObserver msRunObserverOrNull;
    private final IChromatogramObserver chromatogramObserverOrNull;

    public static DateFormat getDateFormat() {
        DateFormat dateFormat = dateFormatHolder.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            dateFormatHolder.set(dateFormat);
        }
        return dateFormat;
    }

    public EICMLParser(String fileName, IMSRunObserver msRunObserverOrNull, IChromatogramObserver chromatogramObserverOrNull) throws ParserConfigurationException, SAXException, IOException {
        assert (fileName != null);
        this.msRunObserverOrNull = msRunObserverOrNull;
        this.chromatogramObserverOrNull = chromatogramObserverOrNull;
        this.parseDocument(fileName);
    }

    private void parseDocument(String fileName) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(fileName, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.buffer.setLength(0);
        if (MS_RUN.equals(name)) {
            this.msRun = new EICMSRunDTO();
            this.parsingMsRun = true;
        } else if ("chromatogram".equals(name)) {
            this.chromatogram = new ChromatogramDTO();
            this.parsingChromatogram = true;
        }
    }

    private float[] convert(String b64) {
        byte[] decoded = Base64.decodeBase64((byte[])b64.getBytes());
        return NativeData.byteToFloat((byte[])decoded, (NativeData.ByteOrder)NativeData.ByteOrder.BIG_ENDIAN);
    }

    void setMsRun(String name, String value) throws SAXException {
        if ("filePath".equals(name)) {
            this.msRun.setRawDataFilePath(value);
        } else if ("fileName".equals(name)) {
            this.msRun.setRawDataFileName(value);
        } else if ("instrumentType".equals(name)) {
            this.msRun.setInstrumentType(value);
        } else if ("instrumentManufacturer".equals(name)) {
            this.msRun.setInstrumentManufacturer(value);
        } else if ("instrumentModel".equals(name)) {
            this.msRun.setInstrumentModel(value);
        } else if ("methodIonisation".equals(name)) {
            this.msRun.setMethodIonisation(value);
        } else if ("methodSeparation".equals(name)) {
            this.msRun.setMethodSeparation(value);
        } else if ("acquisitionDate".equals(name) && StringUtils.isNotBlank((CharSequence)value)) {
            try {
                this.msRun.setAcquisitionDate(EICMLParser.getDateFormat().parse(value));
            }
            catch (ParseException ex) {
                throw new SAXException("Error parsing date: " + value);
            }
        } else if ("chromCount".equals(name) && value.length() > 0) {
            this.msRun.setChromCount(Integer.parseInt(value));
        } else if ("msRunId".equals(name) && value.length() > 0) {
            this.msRun.setMsRunId(Long.parseLong(value));
        } else if ("startTime".equals(name) && value.length() > 0) {
            this.msRun.setStartTime(Float.parseFloat(value));
        } else if ("endTime".equals(name) && value.length() > 0) {
            this.msRun.setEndTime(Float.parseFloat(value));
        } else if ("setId".equals(name)) {
            this.msRun.setSetId(Long.parseLong(value));
        } else if ("operator".equals(name)) {
            this.msRun.setOperator(value);
        }
    }

    void setChromatogram(String name, String value) throws SAXException {
        if ("Q1Mz".equals(name) && value.length() > 0) {
            this.chromatogram.setQ1Mz(Float.parseFloat(value));
        } else if ("Q3LowMz".equals(name) && value.length() > 0) {
            this.chromatogram.setQ3LowMz(Float.parseFloat(value));
        } else if ("Q3HighMz".equals(name) && value.length() > 0) {
            this.chromatogram.setQ3HighMz(Float.parseFloat(value));
        } else if ("label".equals(name) && value.length() > 0) {
            this.chromatogram.setLabel(value);
        } else if ("polarity".equals(name) && value.length() > 0) {
            if (value.length() != 1) {
                throw new SAXException("Illegal polarity: must be of length 1");
            }
            this.chromatogram.setPolarity(value.charAt(0));
        } else if ("RT".equals(name) && value.length() > 0) {
            this.chromatogram.setRunTimes(this.convert(value));
        } else if ("INT".equals(name) && value.length() > 0) {
            this.chromatogram.setIntensities(this.convert(value));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (MS_RUN.equals(name)) {
            this.parsingMsRun = false;
            if (this.msRunObserverOrNull != null) {
                this.msRunObserverOrNull.observe(this.msRun);
            }
            this.msRun = null;
        } else if ("chromatogram".equals(name)) {
            this.parsingChromatogram = false;
            if (this.chromatogramObserverOrNull != null) {
                this.chromatogramObserverOrNull.observe(this.chromatogram);
            }
            this.chromatogram = null;
        }
        if (this.parsingMsRun && this.msRun != null) {
            this.setMsRun(name, this.buffer.toString());
        } else if (this.parsingChromatogram && this.chromatogram != null) {
            this.setChromatogram(name, this.buffer.toString());
        }
        this.buffer.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(new String(ch, start, length));
    }

    public static interface IChromatogramObserver {
        public void observe(ChromatogramDTO var1);
    }

    public static interface IMSRunObserver {
        public void observe(EICMSRunDTO var1);
    }
}

