/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.etlserver.utils.PreprocessingExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import ch.systemsx.cisd.yeastx.etl.DatasetMappingResolver;
import ch.systemsx.cisd.yeastx.etl.DatasetMappingUtil;
import ch.systemsx.cisd.yeastx.etl.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class BatchDataSetHandler
implements IDataSetHandler {
    private final IDataSetHandler delegator;
    private final IMailClient mailClient;
    private final DatasetMappingResolver datasetMappingResolver;
    private final PreprocessingExecutor writeAccessSetter;

    public BatchDataSetHandler(Properties parentProperties, IDataSetHandler delegator, IEncapsulatedOpenBISService openbisService) {
        this.delegator = delegator;
        this.mailClient = new MailClient(parentProperties);
        Properties specificProperties = BatchDataSetHandler.getSpecificProperties(parentProperties);
        this.datasetMappingResolver = new DatasetMappingResolver(specificProperties, openbisService);
        this.writeAccessSetter = PreprocessingExecutor.create((Properties)specificProperties);
    }

    private static Properties getSpecificProperties(Properties properties) {
        return ExtendedProperties.getSubset((Properties)properties, (String)"dataset-handler.", (boolean)true);
    }

    public List<DataSetInformation> handleDataSet(File batchDir) {
        if (!BatchDataSetHandler.canBatchBeProcessed(batchDir)) {
            return BatchDataSetHandler.createEmptyResult();
        }
        LogUtils log = new LogUtils(batchDir);
        if (!this.callPreprocessingScript(batchDir, log)) {
            return this.flushErrors(batchDir, null, log);
        }
        DatasetMappingUtil.DataSetMappingInformationFile mappingFile = DatasetMappingUtil.tryGetDatasetsMapping(batchDir, log);
        if (mappingFile == null || mappingFile.tryGetMappings() == null) {
            return this.flushErrors(batchDir, mappingFile, log);
        }
        return this.processDatasets(batchDir, log, mappingFile.tryGetMappings(), mappingFile.getNotificationEmail());
    }

    private ArrayList<DataSetInformation> flushErrors(File batchDir, DatasetMappingUtil.DataSetMappingInformationFile datasetMappingFileOrNull, LogUtils log) {
        BatchDataSetHandler.touchErrorMarkerFile(batchDir, log);
        this.sendNotificationsIfNecessary(log, BatchDataSetHandler.tryGetEmail(datasetMappingFileOrNull));
        return BatchDataSetHandler.createEmptyResult();
    }

    private boolean callPreprocessingScript(File batchDir, LogUtils log) {
        boolean ok = this.writeAccessSetter.execute(batchDir.getName());
        if (!ok) {
            String errorMsg = String.format("No datasets from '%s' directory can be processed because the try to acquire write access by openBIS has failed.", batchDir.getName());
            log.error(errorMsg + " Try again after some time or contact your administrator.", new Object[0]);
            log.adminError(errorMsg, new Object[0]);
        }
        return ok;
    }

    private List<DataSetInformation> processDatasets(File batchDir, LogUtils log, TableMap<String, DataSetMappingInformation> mappings, String notificationEmail) {
        ArrayList<DataSetInformation> processedDatasetFiles = BatchDataSetHandler.createEmptyResult();
        HashSet<String> unknownMappings = new HashSet<String>(mappings.keySet());
        HashSet<String> processedFiles = new HashSet<String>();
        List<File> files = BatchDataSetHandler.listAll(batchDir);
        for (File file : files) {
            unknownMappings.remove(file.getName().toLowerCase());
            boolean isWritable = this.acquireWriteAccessWithoutRetries(batchDir, file, log);
            if (!isWritable) {
                this.logNonWritable(file, log);
                continue;
            }
            if (!this.canDatasetBeProcessed(file, mappings, log)) continue;
            List<DataSetInformation> processed = this.delegateProcessing(file, log);
            processedDatasetFiles.addAll(processed);
            if (processed.size() <= 0) continue;
            processedFiles.add(file.getName().toLowerCase());
        }
        if (unknownMappings.size() > 0) {
            this.logUnknownMappings(unknownMappings, log);
        }
        BatchDataSetHandler.clean(batchDir, processedFiles, log, mappings.values().size());
        this.sendNotificationsIfNecessary(log, notificationEmail);
        return processedDatasetFiles;
    }

    private List<DataSetInformation> delegateProcessing(File dataset, LogUtils log) {
        try {
            return this.delegator.handleDataSet(dataset);
        }
        catch (UserFailureException e) {
            log.datasetFileError(dataset, "unexpected error occured, the dataset has been moved to the error directory. The reason is: " + e.getMessage(), new Object[0]);
            return BatchDataSetHandler.createEmptyResult();
        }
    }

    private void logUnknownMappings(Set<String> unknownMappings, LogUtils log) {
        String unknownFiles = CollectionUtils.abbreviate(unknownMappings, (int)-1);
        log.error("There are following files mentioned in the mapping file which do not exist:\n" + unknownFiles + "\nBrowse the mapping file and check if you have not misspelled some file names.", new Object[0]);
    }

    private void logNonWritable(File file, LogUtils log) {
        log.error("Could not acquire write access to '%s'. Try again or contact your administrator.", file.getPath());
    }

    private boolean acquireWriteAccessWithoutRetries(File batchDir, File file, LogUtils log) {
        if (!file.exists()) {
            log.error("File '%s' does not exist.", file.getPath());
            return false;
        }
        if (!BatchDataSetHandler.isWritable(file)) {
            String path = batchDir.getName() + System.getProperty("file.separator") + file.getName();
            boolean ok = this.writeAccessSetter.executeOnce(path);
            if (!ok) {
                log.adminError("Cannot acquire write access to '%s' because write access setter failed", path);
            }
            return BatchDataSetHandler.isWritable(file);
        }
        return true;
    }

    private static boolean isWritable(File file) {
        return file.canWrite();
    }

    private void sendNotificationsIfNecessary(LogUtils log, String email) {
        log.sendNotificationsIfNecessary(this.mailClient, email);
    }

    private static String tryGetEmail(DatasetMappingUtil.DataSetMappingInformationFile datasetMappingFileOrNull) {
        return datasetMappingFileOrNull == null ? null : datasetMappingFileOrNull.getNotificationEmail();
    }

    private static ArrayList<DataSetInformation> createEmptyResult() {
        return new ArrayList<DataSetInformation>();
    }

    private static boolean canBatchBeProcessed(File batchDir) {
        if (!batchDir.isDirectory()) {
            return false;
        }
        if (BatchDataSetHandler.errorMarkerFileExists(batchDir)) {
            return false;
        }
        if (!DatasetMappingUtil.isMappingFilePresent(batchDir)) {
            return false;
        }
        List<File> files = BatchDataSetHandler.listAll(batchDir);
        return files.size() != 0;
    }

    private static boolean errorMarkerFileExists(File batchDir) {
        return new File(batchDir, "_delete_me_after_correcting_errors").isFile();
    }

    private static void cleanMappingFile(File batchDir, Set<String> processedFiles, LogUtils log) {
        DatasetMappingUtil.cleanMappingFile(batchDir, processedFiles, log);
    }

    private static void clean(File batchDir, Set<String> processedFiles, LogUtils log, int datasetMappingsNumber) {
        BatchDataSetHandler.cleanMappingFile(batchDir, processedFiles, log);
        int unprocessedDatasetsCounter = datasetMappingsNumber - processedFiles.size();
        boolean hasNoPotentialDatasetFiles = BatchDataSetHandler.hasNoPotentialDatasetFiles(batchDir);
        if (unprocessedDatasetsCounter == 0 && hasNoPotentialDatasetFiles) {
            BatchDataSetHandler.cleanDatasetsDir(batchDir, log);
        } else {
            BatchDataSetHandler.touchErrorMarkerFile(batchDir, log);
        }
    }

    private static void touchErrorMarkerFile(File batchDir, LogUtils log) {
        File errorMarkerFile = new File(batchDir, "_delete_me_after_correcting_errors");
        if (errorMarkerFile.isFile()) {
            return;
        }
        boolean ok = false;
        try {
            ok = errorMarkerFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!ok) {
            log.adminError("Could not create an error marker file '%s'.", errorMarkerFile.getPath());
        } else {
            log.warning("Correct the errors and delete the '%s' file to start processing again.", "_delete_me_after_correcting_errors");
        }
    }

    private static void cleanDatasetsDir(File batchDir, LogUtils log) {
        LogUtils.deleteUserLog(batchDir);
        DatasetMappingUtil.deleteMappingFile(batchDir, log);
        BatchDataSetHandler.deleteEmptyDir(batchDir);
    }

    private boolean canDatasetBeProcessed(File file, TableMap<String, DataSetMappingInformation> datasetsMapping, LogUtils log) {
        if (!BatchDataSetHandler.isPotentialDatasetFile(file)) {
            return false;
        }
        DataSetMappingInformation mapping = DatasetMappingUtil.tryGetDatasetMapping(file, datasetsMapping);
        if (mapping == null) {
            log.error(file.getName() + " - no mapping could be found for this dataset", new Object[0]);
            return false;
        }
        return this.datasetMappingResolver.isMappingCorrect(mapping, log);
    }

    private static boolean deleteEmptyDir(File dir) {
        boolean ok = dir.delete();
        if (!ok) {
            LogUtils.adminWarn("The directory '%s' cannot be deleted although it seems to be empty.", dir.getPath());
        }
        return ok;
    }

    private static boolean hasNoPotentialDatasetFiles(File batchDir) {
        List<File> files = BatchDataSetHandler.listAll(batchDir);
        int datasetsCounter = files.size();
        for (File file : files) {
            if (BatchDataSetHandler.isPotentialDatasetFile(file)) continue;
            --datasetsCounter;
        }
        return datasetsCounter == 0;
    }

    private static boolean isPotentialDatasetFile(File file) {
        return !LogUtils.isUserLog(file) && !DatasetMappingUtil.isMappingFile(file);
    }

    private static List<File> listAll(File dataSet) {
        List files = FileUtilities.listFilesAndDirectories((File)dataSet, (boolean)false, null);
        Collections.sort(files);
        return files;
    }
}

