/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

class LogUtils {
    private static final String ERROR_NOTIFICATION_EMAIL_SUBJECT = "[openBIS] problems with datasets upload in directory: %s";
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, LogUtils.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, LogUtils.class);
    private final File loggingDir;
    private final StringBuffer userErrorMessages;
    private final StringBuffer adminErrorMessages;

    public LogUtils(File loggingDir) {
        this.loggingDir = loggingDir;
        this.userErrorMessages = new StringBuffer();
        this.adminErrorMessages = new StringBuffer();
    }

    public void datasetMappingError(DataSetMappingInformation mapping, String errorMessageFormat, Object ... arguments) {
        this.datasetMappingError(mapping.getFileName(), errorMessageFormat, arguments);
    }

    public void datasetFileError(File dataset, Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = exception.toString();
        }
        this.datasetFileError(dataset, message, new Object[0]);
    }

    public void datasetFileError(File dataset, String errorMessageFormat, Object ... arguments) {
        this.datasetMappingError(dataset.getName(), errorMessageFormat, arguments);
    }

    private void datasetMappingError(String fileName, String errorMessageFormat, Object ... arguments) {
        String errorMessage = String.format(errorMessageFormat, arguments);
        this.error(fileName + " - cannot upload the file: " + errorMessage, new Object[0]);
    }

    public void mappingFileError(File mappingFile, String messageFormat, Object ... arguments) {
        String errorMessage = String.format(messageFormat, arguments);
        this.error("No datasets could be processed, because there is an error in the mapping file " + mappingFile.getName() + ": " + errorMessage, new Object[0]);
    }

    public void error(String messageFormat, Object ... arguments) {
        this.logError(messageFormat, arguments);
        this.appendUserNotification(messageFormat, arguments);
    }

    public void warning(String messageFormat, Object ... arguments) {
        this.logWarning(messageFormat, arguments);
        this.appendUserNotification(messageFormat, arguments);
    }

    private void appendUserNotification(String messageFormat, Object ... arguments) {
        this.appendNotification(this.userErrorMessages, messageFormat, arguments);
    }

    private void appendNotification(StringBuffer messages, String messageFormat, Object ... arguments) {
        messages.append(String.format(messageFormat, arguments));
        messages.append("\r\n");
    }

    public void sendNotificationsIfNecessary(IMailClient mailClient, String notificationEmailOrNull) {
        if (notificationEmailOrNull != null && this.userErrorMessages.length() > 0) {
            this.sendErrorMessage(mailClient, notificationEmailOrNull);
        }
        if (this.adminErrorMessages.length() > 0) {
            notificationLog.error((Object)this.adminErrorMessages.toString());
        }
    }

    private void sendErrorMessage(IMailClient mailClient, String notificationEmail) {
        String subject = String.format(ERROR_NOTIFICATION_EMAIL_SUBJECT, this.loggingDir.getName());
        mailClient.sendMessage(subject, this.createErrorNotificationContent(), null, null, new String[]{notificationEmail});
    }

    private String createErrorNotificationContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("Hello,\n");
        sb.append("This email has been generated automatically by openBIS.\n\n");
        sb.append("The upload of some datasets from '");
        sb.append(this.loggingDir.getName());
        sb.append("' directory has failed.\nThere are following errors:\n");
        sb.append(this.userErrorMessages);
        sb.append("\n");
        sb.append("If you are not sure how to correct the errors and you cannot find the answer in the documentation, ask for help your openBIS administrator.\n\n");
        sb.append("Kind regards,\n");
        sb.append("   openBIS Team");
        return sb.toString();
    }

    private void logError(String messageFormat, Object ... arguments) {
        String message = LogUtils.createUserMessage("ERROR", messageFormat, arguments);
        this.notifyUserByLogFile(message);
    }

    private void logWarning(String messageFormat, Object ... arguments) {
        String message = LogUtils.createUserMessage("WARNING", messageFormat, arguments);
        this.notifyUserByLogFile(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUserByLogFile(String message) {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(LogUtils.getUserLogFile(this.loggingDir), true);
            IOUtils.writeLines(Arrays.asList(message), (String)"", (OutputStream)output);
        }
        catch (IOException ex) {
            try {
                this.adminError("Cannot notify a user because " + ex.getMessage() + "\n The message was: " + message, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    private static String createUserMessage(String messageKind, String messageFormat, Object ... arguments) {
        String now = new Date().toString();
        String message = now + " " + messageKind + ": " + LogUtils.format(messageFormat, arguments) + "\r\n";
        return message;
    }

    private static File getUserLogFile(File loggingDir) {
        return new File(loggingDir, "error-log.txt");
    }

    public void adminError(String messageFormat, Object ... arguments) {
        this.appendNotification(this.adminErrorMessages, messageFormat, arguments);
    }

    public static void adminWarn(String messageFormat, Object ... arguments) {
        operationLog.warn((Object)LogUtils.format(messageFormat, arguments));
    }

    public static void adminInfo(String messageFormat, Object ... arguments) {
        operationLog.info((Object)LogUtils.format(messageFormat, arguments));
    }

    private static String format(String messageFormat, Object ... arguments) {
        return String.format(messageFormat, arguments);
    }

    public static boolean isUserLog(File file) {
        return file.getName().equals("error-log.txt");
    }

    public static boolean deleteUserLog(File loggingDir) {
        File file = LogUtils.getUserLogFile(loggingDir);
        if (file.isFile()) {
            return file.delete();
        }
        return true;
    }
}

