/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.etlserver.IDataSetUploader;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.yeastx.db.IDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.eicml.EICML2Database;
import ch.systemsx.cisd.yeastx.etl.DataSetInformationYeastX;
import ch.systemsx.cisd.yeastx.etl.DatasetMappingResolver;
import ch.systemsx.cisd.yeastx.etl.MLConversionType;
import ch.systemsx.cisd.yeastx.fiaml.FIAML2Database;
import ch.systemsx.cisd.yeastx.mzxml.MzXml2Database;
import ch.systemsx.cisd.yeastx.quant.QuantML2Database;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;

public class ML2DatabaseUploader
implements IDataSetUploader {
    private static final String UNKNOWN_NAME = "unknown";
    private final IDatasetLoader eicML2Database;
    private final IDatasetLoader fiaML2Database;
    private final IDatasetLoader quantML2Database;
    private final IDatasetLoader mzXml2Database;
    private final String uniqueSampleNamePropertyCode;
    private final String uniqueExperimentNamePropertyCode;
    private IDatasetLoader currentTransaction;

    public ML2DatabaseUploader(Properties properties) {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.eicML2Database = new EICML2Database(dataSource);
        this.fiaML2Database = new FIAML2Database(dataSource);
        this.quantML2Database = new QuantML2Database(dataSource);
        this.mzXml2Database = new MzXml2Database(dataSource);
        this.currentTransaction = null;
        this.uniqueExperimentNamePropertyCode = DatasetMappingResolver.getUniqueExperimentNamePropertyCode(properties);
        this.uniqueSampleNamePropertyCode = DatasetMappingResolver.getUniqueSampleNamePropertyCode(properties);
    }

    public void upload(File dataSet, DataSetInformation dataSetInformation) throws EnvironmentFailureException {
        this.uploadData(dataSet, dataSetInformation.tryToGetSample(), dataSetInformation.tryToGetExperiment(), dataSetInformation.getDataSetCode(), dataSetInformation);
    }

    public void upload(File dataSet, Sample sampleOrNull, Experiment experiment, String dataSetCode) {
        this.uploadData(dataSet, sampleOrNull, experiment, dataSetCode, null);
    }

    private void uploadData(File dataSet, Sample sample, Experiment experiment, String dataSetCode, DataSetInformation dataSetInformationOrNull) {
        try {
            if (this.currentTransaction != null) {
                throw new IllegalStateException("Current transaction has been neither commited nor rollbacked.");
            }
            this.currentTransaction = this.tryGetDatasetUploader(dataSet, ML2DatabaseUploader.isMZXMLWithNoConversion(dataSet, dataSetInformationOrNull));
            if (this.currentTransaction != null) {
                DMDataSetDTO openbisBacklink = this.createBacklink(dataSetCode, sample, experiment);
                this.currentTransaction.upload(dataSet, openbisBacklink);
            }
        }
        catch (SQLException e) {
            throw EnvironmentFailureException.fromTemplate((Throwable)e, (String)"A database error occured while extracting additional information from '%s' file content for '%s' dataset.", (Object[])new Object[]{dataSet.getPath(), dataSetCode});
        }
    }

    private IDatasetLoader tryGetDatasetUploader(File dataSet, boolean isMZXML) throws SQLException {
        String extension = ML2DatabaseUploader.getExtension(dataSet);
        if (extension.equalsIgnoreCase("fiaML")) {
            return this.fiaML2Database;
        }
        if (extension.equalsIgnoreCase("eicML")) {
            return this.eicML2Database;
        }
        if (extension.equalsIgnoreCase("quantML")) {
            return this.quantML2Database;
        }
        if (isMZXML) {
            return this.mzXml2Database;
        }
        return null;
    }

    private static boolean isMZXMLWithNoConversion(File dataSet, DataSetInformation dataSetInformationOrNull) {
        boolean isMZXMLExtension = ML2DatabaseUploader.getExtension(dataSet).equalsIgnoreCase("mzXML");
        boolean dataSetUndefined = dataSetInformationOrNull == null;
        return isMZXMLExtension && (dataSetUndefined || dataSetInformationOrNull instanceof DataSetInformationYeastX && ((DataSetInformationYeastX)dataSetInformationOrNull).getConversion() == MLConversionType.NONE);
    }

    public void commit() {
        try {
            if (this.currentTransaction != null) {
                this.currentTransaction.commit();
            }
        }
        finally {
            this.currentTransaction = null;
        }
    }

    public void rollback() {
        try {
            if (this.currentTransaction != null) {
                this.currentTransaction.rollback();
            }
        }
        finally {
            this.currentTransaction = null;
        }
    }

    private DMDataSetDTO createBacklink(String datasetPermId, Sample sample, Experiment experiment) {
        String sampleName = UNKNOWN_NAME;
        String sampPermIdOrNull = null;
        if (sample != null) {
            sampleName = this.findSampleName(sample.getProperties());
            sampPermIdOrNull = sample.getPermId();
        }
        if (experiment == null) {
            throw new EnvironmentFailureException("No information about the experiment connected to a dataset " + datasetPermId);
        }
        String experimentName = this.findExperimentName(experiment.getProperties());
        return new DMDataSetDTO(datasetPermId, sampPermIdOrNull, sampleName, experiment.getPermId(), experimentName);
    }

    private String findSampleName(List<? extends IEntityProperty> properties) {
        return ML2DatabaseUploader.findProperty(properties, this.uniqueSampleNamePropertyCode);
    }

    private String findExperimentName(List<? extends IEntityProperty> properties) {
        return ML2DatabaseUploader.findProperty(properties, this.uniqueExperimentNamePropertyCode);
    }

    private static String findProperty(List<? extends IEntityProperty> properties, String propertyTypeCode) {
        for (IEntityProperty iEntityProperty : properties) {
            String currentPropertyCode = iEntityProperty.getPropertyType().getCode();
            if (!currentPropertyCode.equalsIgnoreCase(propertyTypeCode)) continue;
            return iEntityProperty.getValue();
        }
        return UNKNOWN_NAME;
    }

    private static String getExtension(File incomingDataSetPath) {
        return FilenameUtils.getExtension((String)incomingDataSetPath.getName()).toLowerCase();
    }
}

