/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.fiaml;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.yeastx.fiaml.FIAMSRunDTO;
import ch.systemsx.cisd.yeastx.fiaml.FIAMSRunDataDTO;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FIAMLParser
extends DefaultHandler {
    private static final String FIA_RUN = "fiaRun";
    private static final ThreadLocal<DateFormat> dateFormatHolder = new ThreadLocal();
    private StringBuilder buffer = new StringBuilder();
    private FIAMSRunDTO msRun;
    private FIAMSRunDataDTO fiaRunData;
    private boolean parsingMsRun;
    private final IMSRunObserver msRunObserverOrNull;

    public static DateFormat getDateFormat() {
        DateFormat dateFormat = dateFormatHolder.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            dateFormatHolder.set(dateFormat);
        }
        return dateFormat;
    }

    public FIAMLParser(String fileName, IMSRunObserver msRunObserverOrNull) throws ParserConfigurationException, SAXException, IOException {
        assert (fileName != null);
        this.msRunObserverOrNull = msRunObserverOrNull;
        this.parseDocument(fileName);
    }

    private void parseDocument(String fileName) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(fileName, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.buffer.setLength(0);
        if (FIA_RUN.equals(name)) {
            this.msRun = new FIAMSRunDTO();
            this.fiaRunData = new FIAMSRunDataDTO();
            this.parsingMsRun = true;
        }
    }

    private float[] convert(String b64) {
        byte[] decoded = Base64.decodeBase64((byte[])b64.getBytes());
        return NativeData.byteToFloat((byte[])decoded, (NativeData.ByteOrder)NativeData.ByteOrder.BIG_ENDIAN);
    }

    void setMsRun(String name, String value) throws SAXException {
        if ("filePath".equals(name)) {
            this.msRun.setRawDataFilePath(value);
        } else if ("fileName".equals(name)) {
            this.msRun.setRawDataFileName(value);
        } else if ("instrumentType".equals(name)) {
            this.msRun.setInstrumentType(value);
        } else if ("instrumentManufacturer".equals(name)) {
            this.msRun.setInstrumentManufacturer(value);
        } else if ("instrumentModel".equals(name)) {
            this.msRun.setInstrumentModel(value);
        } else if ("methodIonisation".equals(name)) {
            this.msRun.setMethodIonisation(value);
        } else if ("methodSeparation".equals(name)) {
            this.msRun.setMethodSeparation(value);
        } else if ("polarity".equals(name) || "methodPolarity".equals(name)) {
            if (value.length() != 1) {
                throw new SAXException("Illegal polarity: must be of length 1");
            }
            this.msRun.setPolarity(value.charAt(0));
        } else if ("lowMz".equals(name)) {
            this.msRun.setLowMz(Float.parseFloat(value));
        } else if ("highMz".equals(name)) {
            this.msRun.setHighMz(Float.parseFloat(value));
        } else if ("is".equals(name)) {
            this.msRun.setInternalStandard(Float.parseFloat(value));
        } else if ("od".equals(name)) {
            this.msRun.setOd(Float.parseFloat(value));
        } else if ("operator".equals(name)) {
            this.msRun.setOperator(value);
        } else if ("acquisitionDate".equals(name) && StringUtils.isNotBlank((CharSequence)value)) {
            try {
                this.msRun.setAcquisitionDate(FIAMLParser.getDateFormat().parse(value));
            }
            catch (ParseException ex) {
                throw new SAXException("Error parsing date: " + value);
            }
        } else if ("profileMz".equals(name)) {
            this.fiaRunData.setProfileMz(this.convert(value));
        } else if ("profileInt".equals(name)) {
            this.fiaRunData.setProfileIntensities(this.convert(value));
        } else if ("centroidMz".equals(name)) {
            this.fiaRunData.setCentroidMz(this.convert(value));
        } else if ("centroidInt".equals(name)) {
            this.fiaRunData.setCentroidIntensities(this.convert(value));
        } else if ("centroidCorr".equals(name)) {
            this.fiaRunData.setCentroidCorrelations(this.convert(value));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (FIA_RUN.equals(name)) {
            this.parsingMsRun = false;
            if (this.msRunObserverOrNull != null) {
                this.msRunObserverOrNull.observe(this.msRun, this.fiaRunData);
            }
            this.msRun = null;
            this.fiaRunData = null;
        }
        if (this.parsingMsRun && this.msRun != null && this.fiaRunData != null) {
            this.setMsRun(name, this.buffer.toString());
        }
        this.buffer.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(new String(ch, start, length));
    }

    public static interface IMSRunObserver {
        public void observe(FIAMSRunDTO var1, FIAMSRunDataDTO var2);
    }
}

