/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class FileServiceServlet
extends AbstractServlet {
    public static final String FILE_SERVICE_PATH = "file-service";
    public static final String FILE_SERVICE_PATH_MAPPING = "file-service/**/*";
    private static final String APP_PREFIX = "/file-service/";
    private static final String KEY_PREFIX = "file-server.";
    private static final String REPO_PATH_KEY = "file-server.repository-path";
    private static final String DEFAULT_REPO_PATH = "../../../data/file-server";
    private static final String MAX_SIZE_KEY = "file-server.maximum-file-size-in-MB";
    private static final int DEFAULT_MAX_SIZE = 10;
    private static final String DOWNLOAD_CHECK_KEY = "file-server.download-check";
    private static final boolean DEFAULT_DOWNLOAD_CHECK = true;
    private static final String DOWNLOAD_URL_PLACE_HOLDER = "download-url";
    private static final String ERROR_MESSAGE_PLACE_HOLDER = "error-message";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileServiceServlet.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="application-server_INTERNAL")
    private IApplicationServerApi service;

    @Override
    @RequestMapping(value={"/file-service/**/*", "/openbis/file-service/**/*", "/openbis/openbis/file-service/**/*"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        String fullPath = request.getPathInfo();
        int indexOfPrefix = fullPath.indexOf(APP_PREFIX);
        if (indexOfPrefix < 0) {
            return;
        }
        PathInfo pathInfo = new PathInfo(fullPath.substring(indexOfPrefix + APP_PREFIX.length()));
        File filesRepository = this.getFilesRepository();
        operationLog.info((Object)fullPath);
        if (request instanceof MultipartHttpServletRequest) {
            this.handleUpload((MultipartHttpServletRequest)request, response, filesRepository, pathInfo);
        } else {
            this.handleDownload(request, response, filesRepository, pathInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(HttpServletRequest request, HttpServletResponse response, File filesRepository, PathInfo pathInfo) throws IOException {
        if (!this.canDownload(request)) {
            operationLog.warn((Object)("Download not authorized: " + pathInfo));
            response.sendError(404);
            return;
        }
        File file = new File(filesRepository, pathInfo.getSectionAndPath());
        if (!file.isFile()) {
            operationLog.warn((Object)("Unknown file: " + pathInfo));
            response.sendError(404);
            return;
        }
        response.setContentLength((int)file.length());
        String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file.getName());
        response.setContentType(contentType);
        ServletOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            outputStream = response.getOutputStream();
            inputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            operationLog.info((Object)(file.length() + " bytes of file '" + pathInfo + "' have been deliverd."));
        }
        catch (IOException ex) {
            try {
                operationLog.error((Object)("Delivering file '" + pathInfo + "' failed."), (Throwable)ex);
                response.sendError(404);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    private boolean canDownload(HttpServletRequest request) {
        Properties props = this.configurer.getResolvedProps();
        if (!PropertyUtils.getBoolean((Properties)props, (String)DOWNLOAD_CHECK_KEY, (boolean)true)) {
            return true;
        }
        return this.isSessionActive(request);
    }

    private void handleUpload(MultipartHttpServletRequest multipartRequest, HttpServletResponse response, File filesRepository, PathInfo pathInfo) throws IOException {
        if (!this.isSessionActive((HttpServletRequest)multipartRequest)) {
            this.writeError(multipartRequest, response, pathInfo, "Session time out");
            return;
        }
        Iterator fileNamesIterator = multipartRequest.getFileNames();
        if (!fileNamesIterator.hasNext()) {
            this.writeError(multipartRequest, response, pathInfo, "No file.");
            return;
        }
        String name = (String)fileNamesIterator.next();
        MultipartFile multipartFile = multipartRequest.getFile(name);
        String originalFilename = multipartFile.getOriginalFilename();
        int maxSizeInMB = PropertyUtils.getInt((Properties)this.configurer.getResolvedProps(), (String)MAX_SIZE_KEY, (int)10);
        long maxSize = (long)maxSizeInMB * 0x100000L;
        if (multipartFile.getSize() > maxSize) {
            this.writeError(multipartRequest, response, pathInfo, "File " + originalFilename + " is to large. Maximum allowed size is  " + maxSizeInMB + "MB.");
            return;
        }
        String uuid = UUID.randomUUID().toString();
        String nameUUID = UUID.randomUUID() + "." + FilenameUtils.getExtension((String)originalFilename);
        String filePath = pathInfo.getSection() + "/" + uuid.substring(0, 2) + "/" + uuid.substring(2, 4) + "/" + uuid.substring(4, 6) + "/" + uuid + "/" + nameUUID;
        File file = new File(filesRepository, filePath);
        file.getParentFile().mkdirs();
        multipartFile.transferTo(file);
        operationLog.info((Object)(multipartFile.getSize() + " bytes have been uploaded for file '" + originalFilename + "' and stored in '" + filePath + "'."));
        response.setStatus(200);
        String imageURL = "/openbis/openbis/file-service/" + filePath;
        this.writeDownloadUrl(multipartRequest, response, pathInfo, imageURL);
    }

    private boolean isSessionActive(HttpServletRequest request) {
        return this.service.isSessionActive(this.getSessionToken(request));
    }

    private void writeDownloadUrl(MultipartHttpServletRequest multipartRequest, HttpServletResponse response, PathInfo pathInfo, String downloadUrl) throws IOException {
        this.writeResponse(multipartRequest, response, pathInfo, "download-url-template", DOWNLOAD_URL_PLACE_HOLDER, downloadUrl);
    }

    private void writeError(MultipartHttpServletRequest multipartRequest, HttpServletResponse response, PathInfo pathInfo, String errorMessage) throws IOException {
        operationLog.warn((Object)("Return the following error message for '" + pathInfo + "': " + errorMessage));
        this.writeResponse(multipartRequest, response, pathInfo, "error-message-template", ERROR_MESSAGE_PLACE_HOLDER, errorMessage);
    }

    private void writeResponse(MultipartHttpServletRequest multipartRequest, HttpServletResponse response, PathInfo pathInfo, String type, String placeHolder, String placeHolderValue) throws IOException {
        Template template = this.getTemplate(pathInfo, type, "${" + placeHolder + "}");
        this.bindPlaceholdersToRequestParameters(template, multipartRequest);
        template.attemptToBind(placeHolder, placeHolderValue);
        this.writeResponse(response, template.createText(false));
    }

    private void bindPlaceholdersToRequestParameters(Template template, MultipartHttpServletRequest multipartRequest) {
        for (String placeholderName : template.getPlaceholderNames()) {
            String value = multipartRequest.getParameter(placeholderName);
            if (value == null) continue;
            template.attemptToBind(placeholderName, value);
        }
    }

    private Template getTemplate(PathInfo pathInfo, String type, String defaultValue) {
        String key = "file-server.section_" + pathInfo.getSection() + "." + type;
        String template = this.configurer.getResolvedProps().getProperty(key);
        if (template == null) {
            operationLog.warn((Object)("No template configured for '" + key + "'. Using default template: " + defaultValue));
            template = defaultValue;
        }
        return new Template(template);
    }

    private File getFilesRepository() {
        return new File(this.configurer.getResolvedProps().getProperty(REPO_PATH_KEY, DEFAULT_REPO_PATH));
    }

    private static final class PathInfo {
        private final String sectionAndPath;
        private final String section;

        PathInfo(String sectionAndPath) {
            this.sectionAndPath = sectionAndPath;
            String[] splittedString = sectionAndPath.split("/", 2);
            this.section = splittedString[0];
        }

        public String getSectionAndPath() {
            return this.sectionAndPath;
        }

        public String getSection() {
            return this.section;
        }

        public String toString() {
            return this.sectionAndPath;
        }
    }
}

