/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server;

import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.authentication.IPrincipalProvider;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractServlet;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SingleSignOnServlet
extends AbstractServlet {
    private static final String OPENBIS_COOKIE = "openbis";
    public static final String SERVLET_NAME = "ssos";
    public static final String SESSION_ID_KEY = "session-id-key";
    public static final String DEFAULT_SESSION_ID_KEY = "Shib-Session-ID";
    public static final String USER_ID_KEY = "user-id-key";
    public static final String DEFAULT_USER_ID_KEY = "mail";
    public static final String FIRST_NAME_KEY = "first-name-key";
    public static final String DEFAULT_FIRST_NAME_KEY = "givenName";
    public static final String LAST_NAME_KEY = "last-name-key";
    public static final String DEFAULT_LAST_NAME_KEY = "surname";
    public static final String EMAIL_KEY = "email-key";
    public static final String DEFAULT_EMAIL_KEY = "mail";
    public static final String REDIRECT_URL_PARAMETER_NAME = "redirect-url";
    public static final String REDIRECT_URL_TEMPLATE_PARAMETER_NAME = "redirect-url-template";
    public static final String REDIRECT_URL_KEY = "redirect-url";
    public static final String DEFAULT_REDIRECT_URL = "webapp/eln-lims";
    private static final String SINGLE_SIGN_ON_REDIRECT_URL_TEMPLATE_PROPERTY = "single-sign-on.redirect-url-template";
    private static final String DEFAULT_SINGLE_SIGN_ON_REDIRECT_URL_TEMPLATE = "https://${host}/openbis/webapp/eln-lims";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SingleSignOnServlet.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="session-manager")
    private IOpenBisSessionManager sessionManager;
    @Autowired
    private IApplicationServerInternalApi applicationServerApi;
    private final Map<String, String> sessionTokenBySessionId = new HashMap<String, String>();
    private Template template;

    protected void initServletContext(ServletContext servletContext) {
        this.template = new Template(this.configurer.getResolvedProps().getProperty(SINGLE_SIGN_ON_REDIRECT_URL_TEMPLATE_PROPERTY, DEFAULT_SINGLE_SIGN_ON_REDIRECT_URL_TEMPLATE));
        this.template.createFreshCopy().bind("host", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequestMapping(value={"ssos"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        operationLog.info((Object)"handle sso event");
        this.removeStaleSessions();
        String sessionId = this.getHeader(request, SESSION_ID_KEY, DEFAULT_SESSION_ID_KEY);
        SingleSignOnServlet singleSignOnServlet = this;
        synchronized (singleSignOnServlet) {
            String sessionToken = this.sessionTokenBySessionId.get(sessionId);
            String returnURL = request.getParameter("return");
            if (returnURL != null) {
                this.handleLogOut(request, response, sessionId, sessionToken, returnURL);
            } else {
                this.handleLogIn(request, response, sessionId, sessionToken);
            }
        }
    }

    private void removeStaleSessions() {
        for (Map.Entry<String, String> entry : new ArrayList<Map.Entry<String, String>>(this.sessionTokenBySessionId.entrySet())) {
            String sessionToken = entry.getValue();
            if (this.sessionManager.tryGetSession(sessionToken) != null) continue;
            this.sessionTokenBySessionId.remove(entry.getKey());
        }
    }

    private void handleLogIn(HttpServletRequest request, HttpServletResponse response, String sessionId, String sessionToken) throws IOException {
        Session session;
        if (sessionToken != null && (session = (Session)this.sessionManager.tryGetSession(sessionToken)) != null) {
            sessionToken = session.getSessionToken();
            this.redirectToApp(request, response, sessionToken);
            return;
        }
        String userId = ServerUtils.escapeEmail(this.getHeader(request, USER_ID_KEY, "mail"));
        String firstName = this.getHeader(request, FIRST_NAME_KEY, DEFAULT_FIRST_NAME_KEY);
        String lastName = this.getHeader(request, LAST_NAME_KEY, DEFAULT_LAST_NAME_KEY);
        String email = this.getHeader(request, EMAIL_KEY, "mail");
        final Principal principal = new Principal(userId, firstName, lastName, email, true);
        sessionToken = this.sessionManager.tryToOpenSession(userId, new IPrincipalProvider(){

            public Principal tryToGetPrincipal(String userID) {
                return principal;
            }
        });
        this.applicationServerApi.registerUser(sessionToken);
        this.sessionTokenBySessionId.put(sessionId, sessionToken);
        operationLog.info((Object)("Session token " + sessionToken + " created for SSO session id " + sessionId + " (" + this.sessionTokenBySessionId.size() + ")"));
        this.redirectToApp(request, response, sessionToken);
    }

    private void handleLogOut(HttpServletRequest request, HttpServletResponse response, String sessionId, String sessionToken, String returnURL) throws IOException {
        Session session;
        operationLog.info((Object)("log out session id: " + sessionId));
        this.sessionTokenBySessionId.remove(sessionId);
        if (sessionToken != null && (session = (Session)this.sessionManager.tryGetSession(sessionToken)) != null) {
            this.sessionManager.closeSession(sessionToken);
            operationLog.info((Object)("Session " + sessionToken + " closed."));
        }
        operationLog.info((Object)("Redirect to " + returnURL));
        this.removeOpenbisCookies(request, response);
        response.sendRedirect(returnURL);
    }

    private void redirectToApp(HttpServletRequest request, HttpServletResponse response, String sessionToken) throws IOException {
        String host;
        String redirectUrl = null;
        if (StringUtils.isNotBlank((String)request.getParameter("redirect-url"))) {
            redirectUrl = request.getParameter("redirect-url");
        } else if (StringUtils.isNotBlank((String)request.getParameter(REDIRECT_URL_TEMPLATE_PARAMETER_NAME))) {
            host = request.getHeader("X-Forwarded-Host");
            Template template = new Template(request.getParameter(REDIRECT_URL_TEMPLATE_PARAMETER_NAME)).createFreshCopy();
            template.bind("host", host);
            redirectUrl = template.createText();
        } else {
            host = request.getHeader("X-Forwarded-Host");
            Template template = this.template.createFreshCopy();
            template.bind("host", host);
            redirectUrl = this.configurer.getResolvedProps().getProperty("redirect-url", template.createText());
        }
        operationLog.info((Object)("redirect to " + redirectUrl));
        this.removeOpenbisCookies(request, response);
        Cookie cookie = new Cookie(OPENBIS_COOKIE, sessionToken);
        cookie.setPath("/");
        response.addCookie(cookie);
        response.sendRedirect(redirectUrl);
    }

    private void removeOpenbisCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().equals(OPENBIS_COOKIE)) continue;
            cookie.setValue("");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private String getHeader(HttpServletRequest request, String keyProperty, String defaultKey) {
        String key = this.configurer.getResolvedProps().getProperty(keyProperty, defaultKey);
        String header = request.getHeader(key);
        if (header != null) {
            return header;
        }
        operationLog.error((Object)("Missing header '" + key + "'."));
        throw new IllegalArgumentException("Missing header '" + key + "'.");
    }
}

