/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.cache;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchIgnore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchProperty;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.IFetchOptionsMatcher;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.IFetchPropertyHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class FetchOptionsMatcher
implements IFetchOptionsMatcher {
    private Set<Pair> checked = new HashSet<Pair>();

    public boolean areMatching(Object o1, Object o2) {
        Pair pair = new Pair(o1, o2);
        if (this.checked.contains(pair)) {
            return true;
        }
        this.checked.add(pair);
        return this.arePartsAccessibleViaMethodsMatching(o1, o2) && this.arePartsAccessibleViaFieldsMatching(o1, o2);
    }

    private boolean arePartsAccessibleViaMethodsMatching(Object o1, Object o2) {
        Class<?> clazz = o1.getClass();
        Method method = null;
        try {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                boolean has2;
                method = methods[i];
                method.setAccessible(true);
                if (method.getAnnotation(FetchIgnore.class) != null || !method.getName().startsWith("has") || method.getName().equals("hashCode")) continue;
                boolean has1 = (Boolean)method.invoke(o1, new Object[0]);
                if (has1 != (has2 = ((Boolean)method.invoke(o2, new Object[0])).booleanValue())) {
                    return false;
                }
                if (!has1 || !has2) continue;
                Method withMethod = clazz.getMethod("with" + method.getName().substring(3), new Class[0]);
                Object with1 = withMethod.invoke(o1, new Object[0]);
                Object with2 = withMethod.invoke(o2, new Object[0]);
                if (with1 == null || with2 == null || this.areMatching(with1, with2)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't check if fetch options are matching for class: " + clazz + " and method: " + method, e);
        }
        return true;
    }

    private boolean arePartsAccessibleViaFieldsMatching(Object o1, Object o2) {
        Class<?> clazz = o1.getClass();
        Field field = null;
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Class handlerClass;
                field = fields[i];
                field.setAccessible(true);
                FetchProperty annotation = field.getAnnotation(FetchProperty.class);
                if (annotation == null || (handlerClass = annotation.handler()) == null) continue;
                Constructor handlerConstructor = handlerClass.getDeclaredConstructor(new Class[0]);
                handlerConstructor.setAccessible(true);
                IFetchPropertyHandler handler = (IFetchPropertyHandler)handlerConstructor.newInstance(new Object[0]);
                if (handler.areMatching(o1, o2, (IFetchOptionsMatcher)this)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't check if fetch options are matching for class: " + clazz + " and field: " + field, e);
        }
        return true;
    }

    private static class Pair {
        public Object object1;
        public Object object2;

        public Pair(Object object1, Object object2) {
            this.object1 = object1;
            this.object2 = object2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.object1 == null ? 0 : this.object1.hashCode());
            result = 31 * result + (this.object2 == null ? 0 : this.object2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.object1 == other.object1 && this.object2 == other.object2;
        }
    }
}

