/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.context;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgressListener;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgressStack;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.ProgressStack;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Context
implements IContext {
    private final ProgressStack progressStack = new ProgressStack();
    private final Collection<IProgressListener> progressListeners = new ArrayList<IProgressListener>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Session session;

    public Context(Session session) {
        this.session = session;
    }

    @Override
    public void addProgressListener(IProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    private void notifyProgressListeners() {
        for (IProgressListener progressListener : this.progressListeners) {
            progressListener.onProgress(this.progressStack);
        }
    }

    @Override
    public void pushProgress(IProgress progress) {
        this.progressStack.push(progress);
        this.notifyProgressListeners();
    }

    @Override
    public IProgress popProgress() {
        return this.progressStack.pop();
    }

    @Override
    public IProgressStack getProgressStack() {
        return this.progressStack;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }
}

