/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.context;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgressStack;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.ProgressFormatter;
import java.util.Iterator;
import java.util.Stack;

class ProgressStack
implements IProgressStack {
    private Stack<IProgress> stack = new Stack();

    ProgressStack() {
    }

    void push(IProgress progress) {
        this.stack.push(progress);
    }

    IProgress pop() {
        return this.stack.pop();
    }

    @Override
    public Iterator<IProgress> iterator() {
        return new Iterator<IProgress>(){
            int index;
            {
                this.index = ProgressStack.this.stack.size();
            }

            @Override
            public boolean hasNext() {
                return this.index > 0;
            }

            @Override
            public IProgress next() {
                return (IProgress)ProgressStack.this.stack.get(--this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<IProgress> iterator = this.iterator();
        while (iterator.hasNext()) {
            IProgress progress = iterator.next();
            sb.append(ProgressFormatter.format(progress));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

