/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.Progress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.ICreateAttachmentExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentContentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateAttachmentExecutor
implements ICreateAttachmentExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    private CreateAttachmentExecutor() {
    }

    public CreateAttachmentExecutor(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public void create(IOperationContext context, Map<AttachmentHolderPE, Collection<? extends AttachmentCreation>> attachmentsMap) {
        if (attachmentsMap == null || attachmentsMap.isEmpty()) {
            return;
        }
        LinkedList<AttachmentPE> attachments = new LinkedList<AttachmentPE>();
        for (Map.Entry<AttachmentHolderPE, Collection<? extends AttachmentCreation>> entry : attachmentsMap.entrySet()) {
            AttachmentHolderPE holder = entry.getKey();
            if (holder == null) {
                throw new UserFailureException("Atachment holder cannot be null");
            }
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (AttachmentCreation attachmentCreation : entry.getValue()) {
                if (attachmentCreation == null) continue;
                AttachmentPE attachment = this.createAttachment(context, holder, attachmentCreation);
                attachments.add(attachment);
            }
        }
        try {
            this.daoFactory.getAttachmentDAO().createAttachments(attachments);
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "attachment", null);
            return;
        }
    }

    public AttachmentPE createAttachment(IOperationContext context, AttachmentHolderPE holder, AttachmentCreation attachment) {
        String fileName = attachment.getFileName();
        if (fileName == null) {
            throw new UserFailureException("Unspecified attachment file name.");
        }
        context.pushProgress(new Progress("register attachment '" + fileName + "'"));
        if (attachment.getContent() == null) {
            throw new UserFailureException("Unspecified attachment content.");
        }
        AttachmentPE attachmentPE = new AttachmentPE();
        attachmentPE.setFileName(AttachmentHolderPE.escapeFileName(fileName));
        attachmentPE.setDescription(attachment.getDescription());
        attachmentPE.setTitle(attachment.getTitle());
        AttachmentContentPE attachmentContent = new AttachmentContentPE();
        attachmentContent.setValue(attachment.getContent());
        attachmentPE.setAttachmentContent(attachmentContent);
        attachmentPE.setRegistrator(context.getSession().tryGetPerson());
        attachmentPE.setParent(holder);
        context.popProgress();
        return attachmentPE;
    }
}

