/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.id.AttachmentFileName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.id.IAttachmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.IDeleteAttachmentExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteAttachmentExecutor
implements IDeleteAttachmentExecutor {
    private IAttachmentDAO attachmentDAO;

    @Override
    public void delete(IOperationContext context, AttachmentHolderPE attachmentHolder, Collection<? extends IAttachmentId> attachmentIds) {
        for (IAttachmentId iAttachmentId : attachmentIds) {
            if (iAttachmentId instanceof AttachmentFileName) {
                this.delete(context, attachmentHolder, ((AttachmentFileName)iAttachmentId).getFileName());
                continue;
            }
            throw new UnsupportedObjectIdException((IObjectId)iAttachmentId);
        }
    }

    private void delete(IOperationContext context, AttachmentHolderPE attachmentHolder, String fileName) {
        PersonPE registrator = context.getSession().tryGetPerson();
        this.attachmentDAO.deleteAttachments(attachmentHolder, null, Arrays.asList(fileName), registrator);
    }

    @Autowired
    public void setDaoFactory(IDAOFactory daoFactory) {
        this.attachmentDAO = daoFactory.getAttachmentDAO();
    }
}

