/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.id.AttachmentFileName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.update.AttachmentListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.ICreateAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.IDeleteAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.IUpdateAttachmentForEntityExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateAttachmentForEntityExecutor
implements IUpdateAttachmentForEntityExecutor {
    @Autowired
    private ICreateAttachmentExecutor createAttachmentExecutor;
    @Autowired
    private IDeleteAttachmentExecutor deleteAttachmentExecutor;

    @Override
    public void update(IOperationContext context, AttachmentHolderPE attachmentHolder, AttachmentListUpdateValue updates) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (attachmentHolder == null) {
            throw new IllegalArgumentException("Attachment holder cannot be null");
        }
        if (updates != null && updates.hasActions()) {
            this.remove(context, attachmentHolder, updates);
            this.add(context, attachmentHolder, updates);
            this.set(context, attachmentHolder, updates);
        }
    }

    private void add(IOperationContext context, AttachmentHolderPE attachmentHolder, AttachmentListUpdateValue updates) {
        LinkedHashSet added = new LinkedHashSet();
        for (ListUpdateValue.ListUpdateAction action : updates.getActions()) {
            if (!(action instanceof ListUpdateValue.ListUpdateActionAdd)) continue;
            added.addAll(action.getItems());
        }
        if (!added.isEmpty()) {
            this.createAttachmentExecutor.create(context, Collections.singletonMap(attachmentHolder, added));
        }
    }

    private void remove(IOperationContext context, AttachmentHolderPE attachmentHolder, AttachmentListUpdateValue updates) {
        HashSet removed = new HashSet();
        for (ListUpdateValue.ListUpdateAction action : updates.getActions()) {
            if (!(action instanceof ListUpdateValue.ListUpdateActionRemove)) continue;
            removed.addAll(action.getItems());
        }
        if (!removed.isEmpty()) {
            this.deleteAttachmentExecutor.delete(context, attachmentHolder, removed);
        }
    }

    private void set(IOperationContext context, AttachmentHolderPE attachmentHolder, AttachmentListUpdateValue updates) {
        ListUpdateValue.ListUpdateActionSet lastSet = null;
        for (ListUpdateValue.ListUpdateAction action : updates.getActions()) {
            if (!(action instanceof ListUpdateValue.ListUpdateActionSet)) continue;
            lastSet = (ListUpdateValue.ListUpdateActionSet)action;
        }
        if (lastSet != null) {
            Set<AttachmentPE> attachments = attachmentHolder.getAttachments();
            Collection setCreations = lastSet.getItems();
            HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>> map = new HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>>();
            map.put(attachmentHolder, setCreations);
            this.createAttachmentExecutor.create(context, map);
            HashSet<String> setFileNames = new HashSet<String>();
            for (AttachmentCreation setAttachment : setCreations) {
                setFileNames.add(setAttachment.getFileName());
            }
            for (AttachmentPE attachment : attachments) {
                if (setFileNames.contains(attachment.getFileName())) continue;
                this.deleteAttachmentExecutor.delete(context, attachmentHolder, Collections.singletonList(new AttachmentFileName(attachment.getFileName())));
            }
        }
    }
}

