/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.delete.AuthorizationGroupDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.IAuthorizationGroupId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IAuthorizationGroupAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IDeleteAuthorizationGroupExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IMapGroupPEByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAuthorizationGroupBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteAuthorizationGroupExecutor
extends AbstractDeleteEntityExecutor<Void, IAuthorizationGroupId, AuthorizationGroupPE, AuthorizationGroupDeletionOptions>
implements IDeleteAuthorizationGroupExecutor {
    @Autowired
    private IMapGroupPEByIdExecutor mapGroupByIdExecutor;
    @Autowired
    private IAuthorizationGroupAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IAuthorizationGroupId, AuthorizationGroupPE> map(IOperationContext context, List<? extends IAuthorizationGroupId> entityIds, AuthorizationGroupDeletionOptions deletionOptions) {
        return this.mapGroupByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IAuthorizationGroupId entityId, AuthorizationGroupPE entity) {
        this.authorizationExecutor.canDelete(context);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, AuthorizationGroupPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<AuthorizationGroupPE> entities, AuthorizationGroupDeletionOptions deletionOptions) {
        IAuthorizationGroupBO groupBO = this.businessObjectFactory.createAuthorizationGroupBO(context.getSession());
        for (AuthorizationGroupPE group : entities) {
            groupBO.deleteByTechId(new TechId(group.getId()), deletionOptions.getReason());
        }
        return null;
    }
}

