/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.search.AuthorizationGroupSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IAuthorizationGroupAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.ISearchAuthorizationGroupExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.ISearchPersonExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchAuthorizationGroupExecutor
extends AbstractSearchObjectManuallyExecutor<AuthorizationGroupSearchCriteria, AuthorizationGroupPE>
implements ISearchAuthorizationGroupExecutor {
    @Autowired
    private IAuthorizationGroupAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISearchPersonExecutor searchPersonExecutor;

    @Override
    public List<AuthorizationGroupPE> search(IOperationContext context, AuthorizationGroupSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<AuthorizationGroupPE> listAll() {
        return this.daoFactory.getAuthorizationGroupDAO().listAllEntities();
    }

    @Override
    protected Matcher<AuthorizationGroupPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<AuthorizationGroupPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<AuthorizationGroupPE>();
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return new PermIdMatcher();
        }
        if (criteria instanceof PersonSearchCriteria) {
            return new UserMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class UserMatcher
    extends Matcher<AuthorizationGroupPE> {
        private UserMatcher() {
        }

        @Override
        public List<AuthorizationGroupPE> getMatching(IOperationContext context, List<AuthorizationGroupPE> groups, ISearchCriteria criteria) {
            LinkedHashSet<AuthorizationGroupPE> matchingGroups = new LinkedHashSet<AuthorizationGroupPE>();
            for (PersonPE user : SearchAuthorizationGroupExecutor.this.searchPersonExecutor.search(context, (PersonSearchCriteria)criteria)) {
                for (AuthorizationGroupPE group : groups) {
                    if (!group.getPersons().contains(user)) continue;
                    matchingGroups.add(group);
                }
            }
            return new ArrayList<AuthorizationGroupPE>(matchingGroups);
        }
    }

    private class PermIdMatcher
    extends StringFieldMatcher<AuthorizationGroupPE> {
        private PermIdMatcher() {
        }

        @Override
        protected String getFieldValue(AuthorizationGroupPE object) {
            return object.getCode();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<AuthorizationGroupPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, AuthorizationGroupPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof AuthorizationGroupPermId) {
                return object.getCode().equals(((AuthorizationGroupPermId)id).getPermId());
            }
            throw new IllegalArgumentException("Unknown id: " + criteria.getClass());
        }
    }
}

