/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.IAuthorizationGroupId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.update.AuthorizationGroupUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IAuthorizationGroupAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IMapGroupPEByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IUpdateAuthorizationGroupExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.IUpdateAuthorizationGroupUsersExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateAuthorizationGroupExecutor
extends AbstractUpdateEntityExecutor<AuthorizationGroupUpdate, AuthorizationGroupPE, IAuthorizationGroupId, AuthorizationGroupPermId>
implements IUpdateAuthorizationGroupExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IAuthorizationGroupAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapGroupPEByIdExecutor mapGroupByIdExecutor;
    @Autowired
    private IUpdateAuthorizationGroupUsersExecutor updateAuthorizationGroupUsersExecutor;

    @Override
    protected IAuthorizationGroupId getId(AuthorizationGroupUpdate update) {
        return update.getAuthorizationGroupId();
    }

    @Override
    protected AuthorizationGroupPermId getPermId(AuthorizationGroupPE entity) {
        return new AuthorizationGroupPermId(entity.getCode());
    }

    @Override
    protected void checkData(IOperationContext context, AuthorizationGroupUpdate update) {
        if (update.getAuthorizationGroupId() == null) {
            throw new UserFailureException("Authorization id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IAuthorizationGroupId id, AuthorizationGroupPE entity) {
        this.authorizationExecutor.canUpdate(context);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<AuthorizationGroupUpdate, AuthorizationGroupPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            AuthorizationGroupUpdate update = (AuthorizationGroupUpdate)entry.getKey();
            AuthorizationGroupPE group = (AuthorizationGroupPE)entry.getValue();
            if (update.getDescription() == null || !update.getDescription().isModified()) continue;
            group.setDescription((String)update.getDescription().getValue());
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<AuthorizationGroupUpdate, AuthorizationGroupPE> batch) {
        this.updateAuthorizationGroupUsersExecutor.update(context, batch);
    }

    @Override
    protected Map<IAuthorizationGroupId, AuthorizationGroupPE> map(IOperationContext context, Collection<IAuthorizationGroupId> ids) {
        return this.mapGroupByIdExecutor.map(context, ids);
    }

    @Override
    protected List<AuthorizationGroupPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getAuthorizationGroupDAO().listByIds(ids);
    }

    @Override
    protected void save(IOperationContext context, List<AuthorizationGroupPE> entities, boolean clearCache) {
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "authorization group", null);
    }
}

