/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IEventExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingEvent;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventExecutor
implements IEventExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public void persist(IOperationContext context, List<FreezingEvent> freezingEvents) {
        for (FreezingEvent freezingEvent : freezingEvents) {
            EventPE event = new EventPE();
            event.setEventType(EventType.FREEZING);
            event.setEntityType(freezingEvent.getEntityType());
            event.setIdentifiers(Collections.singletonList(freezingEvent.getIdentifier()));
            event.setRegistrator(context.getSession().tryGetPerson());
            event.setReason(freezingEvent.getFreezingFlags().asJson());
            this.daoFactory.getEventDAO().persist(event);
        }
    }
}

