/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperation;
import ch.systemsx.cisd.openbis.generic.server.IConcurrentOperationLimiter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OperationExecutor<OPERATION extends IOperation, RESULT extends IOperationResult>
implements IOperationExecutor {
    @Autowired
    protected IConcurrentOperationLimiter operationLimiter;

    @Override
    public Map<IOperation, IOperationResult> execute(final IOperationContext context, List<? extends IOperation> operations) {
        HashMap<IOperation, IOperationResult> results = new HashMap<IOperation, IOperationResult>();
        Class<OPERATION> operationClass = this.getOperationClass();
        for (IOperation iOperation : operations) {
            if (iOperation == null || !operationClass.isAssignableFrom(iOperation.getClass())) continue;
            final IOperation theOperation = iOperation;
            IOperationResult result = context.isAsync() ? (IOperationResult)this.operationLimiter.executeLimitedWithTimeoutAsync(theOperation.getClass().getSimpleName(), new ConcurrentOperation<RESULT>(){

                @Override
                public RESULT execute() {
                    return OperationExecutor.this.doExecute(context, theOperation);
                }
            }) : (IOperationResult)this.operationLimiter.executeLimitedWithTimeout(theOperation.getClass().getSimpleName(), new ConcurrentOperation<RESULT>(){

                @Override
                public RESULT execute() {
                    return OperationExecutor.this.doExecute(context, theOperation);
                }
            });
            results.put(theOperation, result);
        }
        return results;
    }

    protected abstract Class<? extends OPERATION> getOperationClass();

    protected abstract RESULT doExecute(IOperationContext var1, OPERATION var2);
}

