/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetObjectsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetObjectsOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.OperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.SortAndPage;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractGetObjectsOperationExecutor<OBJECT_ID extends IObjectId, OBJECT_PE, OBJECT, FETCH_OPTIONS extends FetchOptions<?>>
extends OperationExecutor<GetObjectsOperation<OBJECT_ID, FETCH_OPTIONS>, GetObjectsOperationResult<OBJECT_ID, OBJECT>> {
    @Override
    protected GetObjectsOperationResult<OBJECT_ID, OBJECT> doExecute(IOperationContext context, GetObjectsOperation<OBJECT_ID, FETCH_OPTIONS> operation) {
        Map<OBJECT_ID, OBJECT_PE> idToPeMap = this.map(context, operation.getObjectIds(), operation.getFetchOptions());
        if (idToPeMap == null || idToPeMap.isEmpty()) {
            return this.getOperationResult(Collections.emptyMap());
        }
        TranslationContext translationContext = new TranslationContext(context.getSession());
        Map<OBJECT_PE, OBJECT> peToObjectMap = this.translate(translationContext, idToPeMap.values(), operation.getFetchOptions());
        LinkedHashMap<IObjectId, OBJECT> idToObjectMap = new LinkedHashMap<IObjectId, OBJECT>();
        for (Map.Entry<OBJECT_ID, OBJECT_PE> entry : idToPeMap.entrySet()) {
            IObjectId id = (IObjectId)entry.getKey();
            OBJECT_PE pe = entry.getValue();
            OBJECT object = peToObjectMap.get(pe);
            if (object == null) continue;
            idToObjectMap.put(id, object);
        }
        new SortAndPage().sortAndPage(idToObjectMap.values(), null, operation.getFetchOptions());
        return this.getOperationResult(idToObjectMap);
    }

    protected abstract Map<OBJECT_ID, OBJECT_PE> map(IOperationContext var1, List<? extends OBJECT_ID> var2, FETCH_OPTIONS var3);

    protected abstract Map<OBJECT_PE, OBJECT> translate(TranslationContext var1, Collection<OBJECT_PE> var2, FETCH_OPTIONS var3);

    protected abstract GetObjectsOperationResult<OBJECT_ID, OBJECT> getOperationResult(Map<OBJECT_ID, OBJECT> var1);
}

