/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.CreationId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.IMapObjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CreationIdCache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.MapObjectById;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractMapObjectByIdExecutor<ID extends IObjectId, OBJECT>
implements IMapObjectByIdExecutor<ID, OBJECT> {
    protected abstract void checkAccess(IOperationContext var1);

    @Override
    public Map<ID, OBJECT> map(IOperationContext context, Collection<? extends ID> ids) {
        return this.map(context, ids, true);
    }

    @Override
    public Map<ID, OBJECT> map(IOperationContext context, Collection<? extends ID> ids, boolean checkAccess) {
        if (checkAccess) {
            this.checkAccess(context);
        }
        if (ids == null) {
            throw new IllegalArgumentException("Ids were null");
        }
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.containsCreationIds(ids)) {
            Map<ID, OBJECT> map1 = this.doMapByCreationIds(context, ids);
            Map<? extends ID, OBJECT> map2 = this.doMapByNonCreationIds(context, ids);
            map1.putAll(map2);
            return map1;
        }
        return this.doMapByAllIds(context, ids);
    }

    private boolean containsCreationIds(Collection<? extends ID> ids) {
        for (IObjectId id : ids) {
            if (!(id instanceof CreationId)) continue;
            return true;
        }
        return false;
    }

    private Map<ID, OBJECT> doMapByCreationIds(IOperationContext context, Collection<? extends ID> ids) {
        CreationIdCache creationIdCache = CreationIdCache.getInstance(context);
        LinkedList<IObjectId> realIds = new LinkedList<IObjectId>();
        for (IObjectId id : ids) {
            if (!(id instanceof CreationId)) continue;
            IObjectId realId = creationIdCache.getRealId((CreationId)id);
            realIds.add(realId);
        }
        Map realIdToObjectMap = this.doMapByAllIds(context, realIds);
        HashMap<CreationId, OBJECT> creationIdToObjectMap = new HashMap<CreationId, OBJECT>();
        for (Map.Entry entry : realIdToObjectMap.entrySet()) {
            CreationId creationId = creationIdCache.getCreationId((IObjectId)entry.getKey());
            creationIdToObjectMap.put(creationId, entry.getValue());
        }
        return creationIdToObjectMap;
    }

    private Map<ID, OBJECT> doMapByNonCreationIds(IOperationContext context, Collection<? extends ID> ids) {
        LinkedList<IObjectId> realIds = new LinkedList<IObjectId>();
        for (IObjectId id : ids) {
            if (id instanceof CreationId) continue;
            realIds.add(id);
        }
        return this.doMapByAllIds(context, realIds);
    }

    private Map<ID, OBJECT> doMapByAllIds(IOperationContext context, Collection<? extends ID> ids) {
        ArrayList<IListObjectById<? extends ID, OBJECT>> listers = new ArrayList<IListObjectById<? extends ID, OBJECT>>();
        this.addListers(context, listers);
        return new MapObjectById<ID, OBJECT>().map(context, listers, ids);
    }

    protected abstract void addListers(IOperationContext var1, List<IListObjectById<? extends ID, OBJECT>> var2);
}

