/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetServerInformationOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetServerInformationOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetServerPublicInformationOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get.GetServerPublicInformationOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.OperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.IGetServerInformationOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.IGetServerPublicInformationOperationExecutor;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetServerInformationOperationExecutor
extends OperationExecutor<GetServerInformationOperation, GetServerInformationOperationResult>
implements IGetServerInformationOperationExecutor {
    @Autowired
    private IApplicationServerInternalApi server;
    @Resource(name="application-server_INTERNAL")
    private IServer basicServer;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Autowired
    private IGetServerPublicInformationOperationExecutor getPublicInformationExecutor;

    @Override
    protected Class<? extends GetServerInformationOperation> getOperationClass() {
        return GetServerInformationOperation.class;
    }

    @Override
    protected GetServerInformationOperationResult doExecute(IOperationContext context, GetServerInformationOperation operation) {
        TreeMap<String, String> info = new TreeMap<String, String>();
        info.putAll(this.getPublicInformation(context));
        info.put("api-version", this.server.getMajorVersion() + "." + this.server.getMinorVersion());
        info.put("project-samples-enabled", Boolean.toString(this.basicServer.isProjectSamplesEnabled(null)));
        info.put("archiving-configured", Boolean.toString(this.basicServer.isArchivingConfigured(null)));
        info.put("enabled-technologies", this.configurer.getResolvedProps().getProperty("enabled-modules"));
        info.put("create-continuous-sample-codes", this.configurer.getResolvedProps().getProperty("create-continuous-sample-codes"));
        info.put("openbis-version", BuildAndEnvironmentInfo.INSTANCE.getVersion());
        return new GetServerInformationOperationResult(info);
    }

    private Map<String, String> getPublicInformation(IOperationContext context) {
        GetServerPublicInformationOperation operation = new GetServerPublicInformationOperation();
        GetServerPublicInformationOperationResult result = (GetServerPublicInformationOperationResult)this.getPublicInformationExecutor.execute(context, Collections.singletonList(operation)).get(operation);
        return result.getServerInformation();
    }
}

