/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.systemsx.cisd.openbis.generic.shared.basic.IPermIdHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractIdsMatcher<T extends IPermIdHolder>
extends Matcher<T> {
    @Override
    public List<T> getMatching(IOperationContext context, List<T> objects, ISearchCriteria criteria) {
        Collection ids = (Collection)((IdsSearchCriteria)criteria).getFieldValue();
        if (ids != null && !ids.isEmpty()) {
            HashSet<String> permIds = new HashSet<String>();
            for (IObjectId id : ids) {
                boolean wasPossible = this.addPermIdIfPossible(permIds, id);
                if (wasPossible) continue;
                throw new IllegalArgumentException("Unknown id: " + id.getClass());
            }
            ArrayList<IPermIdHolder> matches = new ArrayList<IPermIdHolder>();
            for (IPermIdHolder object : objects) {
                if (!permIds.contains(object.getPermId())) continue;
                matches.add(object);
            }
            return matches;
        }
        return new ArrayList();
    }

    protected abstract boolean addPermIdIfPossible(Collection<String> var1, IObjectId var2);
}

