/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractObjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchOperator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.ISearchObjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchObjectManuallyExecutor<CRITERIA extends AbstractObjectSearchCriteria<?>, OBJECT>
implements ISearchObjectExecutor<CRITERIA, OBJECT> {
    @Autowired
    protected IDAOFactory daoFactory;

    protected abstract Matcher<OBJECT> getMatcher(ISearchCriteria var1);

    @Override
    public List<OBJECT> search(IOperationContext context, CRITERIA criteria) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("Criterion cannot be null");
        }
        return this.getMatching(context, this.listAll(context), criteria);
    }

    protected List<OBJECT> listAll(IOperationContext context) {
        return this.listAll();
    }

    protected List<OBJECT> listAll() {
        throw new UnsupportedOperationException("Non of the listAll methods are implemented.");
    }

    private List<OBJECT> getMatching(IOperationContext context, List<OBJECT> objects, CRITERIA criteria) {
        HashSet matches;
        if (criteria.getCriteria() == null || criteria.getCriteria().isEmpty()) {
            return objects;
        }
        LinkedList<List<OBJECT>> partialMatches = new LinkedList<List<OBJECT>>();
        for (ISearchCriteria subCriteria : criteria.getCriteria()) {
            Matcher<OBJECT> matcher = this.getMatcher(subCriteria);
            List<Object> partialMatch = matcher.getMatching(context, objects, subCriteria);
            if (partialMatch == null) {
                partialMatch = Collections.emptyList();
            }
            partialMatches.add(partialMatch);
        }
        if (SearchOperator.AND.equals((Object)criteria.getOperator())) {
            matches = new HashSet((Collection)partialMatches.get(0));
            for (List list : partialMatches) {
                matches.retainAll(list);
            }
            return new ArrayList(matches);
        }
        if (SearchOperator.OR.equals((Object)criteria.getOperator())) {
            matches = new HashSet();
            for (List list : partialMatches) {
                matches.addAll(list);
            }
            return new ArrayList(matches);
        }
        throw new IllegalArgumentException("Unknown search operator: " + criteria.getOperator());
    }
}

