/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.CacheMode;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.SortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.Sorting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchObjectsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchObjectsOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.cache.SearchCacheCleanupListener;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.OperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.ISearchObjectsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICacheManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.SortAndPage;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ILocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchObjectsOperationExecutor<OBJECT, OBJECT_PE, CRITERIA extends AbstractSearchCriteria, FETCH_OPTIONS extends FetchOptions<OBJECT>>
extends OperationExecutor<SearchObjectsOperation<CRITERIA, FETCH_OPTIONS>, SearchObjectsOperationResult<OBJECT>>
implements ISearchObjectsOperationExecutor {
    private static final String[] SORTS_TO_IGNORE = new String[]{"FETCHED_FIELDS_SCORE"};
    private static final Logger OPERATION_LOG = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractSearchObjectsOperationExecutor.class);
    @Autowired
    private AuthorizationConfig authorizationConfig;
    @Autowired
    private ICacheManager cacheManager;

    protected abstract List<OBJECT_PE> doSearch(IOperationContext var1, CRITERIA var2, FETCH_OPTIONS var3);

    protected abstract Map<OBJECT_PE, OBJECT> doTranslate(TranslationContext var1, Collection<OBJECT_PE> var2, FETCH_OPTIONS var3);

    protected abstract SearchObjectsOperationResult<OBJECT> getOperationResult(SearchResult<OBJECT> var1);

    protected abstract ILocalSearchManager<CRITERIA, OBJECT, OBJECT_PE> getSearchManager();

    @Override
    protected SearchObjectsOperationResult<OBJECT> doExecute(IOperationContext context, SearchObjectsOperation<CRITERIA, FETCH_OPTIONS> operation) {
        AbstractSearchCriteria criteria = (AbstractSearchCriteria)operation.getCriteria();
        FetchOptions fetchOptions = operation.getFetchOptions();
        if (criteria == null) {
            AbstractSearchObjectsOperationExecutor.throwIllegalArgumentException("Criteria cannot be null.");
        }
        if (fetchOptions == null) {
            AbstractSearchObjectsOperationExecutor.throwIllegalArgumentException("Fetch options cannot be null.");
        }
        Collection<OBJECT> allResults = this.searchAndTranslate(context, criteria, fetchOptions);
        List<OBJECT> sortedAndPaged = this.sortAndPage(allResults, criteria, fetchOptions);
        SearchResult searchResult = new SearchResult(sortedAndPaged, allResults.size());
        return this.getOperationResult(searchResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<OBJECT> searchAndTranslate(IOperationContext context, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        CacheMode cacheMode = this.getCacheManager().getCacheClass() != null ? fetchOptions.getCacheMode() : CacheMode.NO_CACHE;
        OPERATION_LOG.info((Object)("Cache mode: " + cacheMode));
        if (CacheMode.NO_CACHE.equals((Object)cacheMode)) {
            return this.doSearchAndTranslate(context, criteria, fetchOptions);
        }
        if (CacheMode.CACHE.equals((Object)cacheMode) || CacheMode.RELOAD_AND_CACHE.equals((Object)cacheMode)) {
            Set<Object> ids;
            Session session = context.getSession();
            synchronized (session) {
                Set cachedIds = this.getCacheEntry(context, criteria, fetchOptions);
                if (cachedIds == null) {
                    ids = new LinkedHashSet<OBJECT_PE>(this.doSearch(context, criteria, fetchOptions));
                    this.populateCache(context, criteria, Collections.unmodifiableSet(ids));
                } else {
                    OPERATION_LOG.info((Object)("Found cache entry " + cachedIds.hashCode() + " that contains search result with " + cachedIds.size() + " object(s)."));
                    ids = cachedIds;
                }
            }
            return this.doTranslate(context, fetchOptions, ids);
        }
        throw new IllegalArgumentException("Unsupported cache mode: " + cacheMode);
    }

    protected void populateCache(IOperationContext context, CRITERIA criteria, Collection<OBJECT_PE> ids) {
        String key = AbstractSearchObjectsOperationExecutor.getMD5Hash(criteria);
        ICache<Object> cache = this.getCacheManager().getCache(context);
        cache.put(key, ids);
    }

    protected Collection<OBJECT> doSearchAndTranslate(IOperationContext context, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        OPERATION_LOG.info((Object)"Searching...");
        List<OBJECT_PE> ids = this.doSearch(context, criteria, fetchOptions);
        OPERATION_LOG.info((Object)("Found " + ids.size() + " object id(s)."));
        return this.doTranslate(context, fetchOptions, ids);
    }

    private Collection<OBJECT> doTranslate(IOperationContext context, FETCH_OPTIONS fetchOptions, Collection<OBJECT_PE> ids) {
        TranslationContext translationContext = new TranslationContext(context.getSession());
        Map<OBJECT_PE, OBJECT> idToObjectMap = this.doTranslate(translationContext, ids, fetchOptions);
        Collection<OBJECT> objects = idToObjectMap.values();
        OPERATION_LOG.info((Object)("Translated " + objects.size() + " object(s)."));
        return objects;
    }

    private List<OBJECT> sortAndPage(Collection<OBJECT> results, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        if (results == null || results.isEmpty()) {
            return Collections.emptyList();
        }
        SortAndPage sap = new SortAndPage();
        Collection<OBJECT> objects = sap.sortAndPage(results, (ISearchCriteria)criteria, (FetchOptions)fetchOptions);
        OPERATION_LOG.info((Object)("Return " + objects.size() + " object(s) after sorting and paging."));
        return new ArrayList<OBJECT>(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<T> getCacheEntry(IOperationContext context, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        Set entry;
        String key = AbstractSearchObjectsOperationExecutor.getMD5Hash(criteria);
        int sessionHashCode = context.getSession().hashCode();
        if (OPERATION_LOG.isDebugEnabled()) {
            OPERATION_LOG.debug((Object)("Will try to lock on session " + sessionHashCode));
        }
        Session session = context.getSession();
        synchronized (session) {
            if (OPERATION_LOG.isDebugEnabled()) {
                OPERATION_LOG.debug((Object)("Locked on session " + sessionHashCode));
            }
            ICache<Object> cache = this.getCacheManager().getCache(context);
            if (CacheMode.RELOAD_AND_CACHE.equals((Object)fetchOptions.getCacheMode())) {
                cache.remove(key);
            }
            if ((entry = (Set)cache.get(key)) == null) {
                context.getSession().addCleanupListener(new SearchCacheCleanupListener(cache, key));
            }
            if (OPERATION_LOG.isDebugEnabled()) {
                OPERATION_LOG.debug((Object)("Released lock on session " + sessionHashCode));
            }
        }
        return entry;
    }

    public Collection<Long> executeDirectSQLSearchForIds(PersonPE personPE, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        AuthorisationInformation authorisationInformation = AuthorisationInformation.getInstance(personPE, this.authorizationConfig);
        Long userId = personPE.getId();
        Set<Long> allResultsIds = this.performDirectSearch(criteria, authorisationInformation, userId);
        return this.sortAndPage(allResultsIds, fetchOptions);
    }

    protected SearchObjectsOperationResult<OBJECT> executeDirectSQLSearch(IOperationContext context, SearchObjectsOperation<CRITERIA, FETCH_OPTIONS> operation) {
        AbstractSearchCriteria criteria = (AbstractSearchCriteria)operation.getCriteria();
        FetchOptions fetchOptions = operation.getFetchOptions();
        if (criteria == null) {
            throw new IllegalArgumentException("Criteria cannot be null.");
        }
        if (fetchOptions == null) {
            throw new IllegalArgumentException("Fetch options cannot be null.");
        }
        Set<Long> ids = this.getIds(context, criteria, fetchOptions);
        Collection<Long> pagedResultIds = this.sortAndPage(ids, fetchOptions);
        Collection pagedResultPEs = this.getSearchManager().map(pagedResultIds);
        TranslationContext translationContext = new TranslationContext(context.getSession());
        Map pagedResultV3DTOs = this.doTranslate(translationContext, pagedResultPEs, fetchOptions);
        if (pagedResultPEs.size() != pagedResultV3DTOs.size()) {
            throw new RuntimeException(String.format("Number of results after translation has changed. Total count value will be incorrect. [pagedResultPEs.size()=%d, pagedResultV3DTOs.size()=%d]", pagedResultPEs.size(), pagedResultV3DTOs.size()));
        }
        List objectResults = pagedResultPEs.stream().map(pagedResultV3DTOs::get).filter(Objects::nonNull).collect(Collectors.toList());
        new SortAndPage().nest(objectResults, (ISearchCriteria)criteria, fetchOptions);
        SearchResult searchResult = new SearchResult(objectResults, ids.size());
        return this.getOperationResult(searchResult);
    }

    private Set<Long> getIds(IOperationContext context, CRITERIA criteria, FETCH_OPTIONS fetchOptions) {
        PersonPE personPE = context.getSession().tryGetPerson();
        AuthorisationInformation authorisationInformation = AuthorisationInformation.getInstance(personPE, this.authorizationConfig);
        Long userId = personPE.getId();
        CacheMode cacheMode = this.getCacheManager().getCacheClass() != null ? fetchOptions.getCacheMode() : CacheMode.NO_CACHE;
        OPERATION_LOG.info((Object)("Cache mode: " + cacheMode));
        if (CacheMode.NO_CACHE.equals((Object)cacheMode)) {
            return this.performDirectSearch(criteria, authorisationInformation, userId);
        }
        if (CacheMode.CACHE.equals((Object)cacheMode) || CacheMode.RELOAD_AND_CACHE.equals((Object)cacheMode)) {
            Set<Object> ids = this.getCacheEntry(context, criteria, fetchOptions);
            if (ids == null) {
                ids = this.performDirectSearch(criteria, authorisationInformation, userId);
                String key = AbstractSearchObjectsOperationExecutor.getMD5Hash(criteria);
                ICache<Object> cache = this.getCacheManager().getCache(context);
                cache.put(key, Collections.unmodifiableSet(ids));
            } else {
                OPERATION_LOG.info((Object)("Found cache entry " + ids.hashCode() + " that contains search result with " + ids.size() + " object(s)."));
            }
            return ids;
        }
        throw new IllegalArgumentException("Unsupported cache mode: " + cacheMode);
    }

    protected static String getMD5Hash(Object criteria) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(criteria.toString().getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private Set<Long> performDirectSearch(CRITERIA criteria, AuthorisationInformation authorisationInformation, Long userId) {
        return this.getSearchManager().searchForIDs(userId, authorisationInformation, criteria, null, "id");
    }

    private Collection<Long> sortAndPage(Set<Long> ids, FETCH_OPTIONS fetchOptions) {
        boolean hasPaging;
        List<Long> toPage;
        List<Long> sortedIds;
        SortOptions sortOptions = fetchOptions.getSortBy();
        if (sortOptions != null) {
            ArrayList<Sorting> sortingToRemove = new ArrayList<Sorting>();
            for (Sorting sorting : sortOptions.getSortings()) {
                for (String sortToIgnore : SORTS_TO_IGNORE) {
                    if (!sorting.getField().equals(sortToIgnore)) continue;
                    sortingToRemove.add(sorting);
                }
            }
            for (Sorting sorting : sortingToRemove) {
                sortOptions.getSortings().remove(sorting);
                OPERATION_LOG.warn((Object)("[SQL Query Engine - backwards compatibility warning - stop using this feature] SORTING ORDER IGNORED!: " + sorting.getField()));
            }
            if (sortOptions.getSortings().isEmpty()) {
                sortOptions = null;
            }
        }
        List<Long> list = sortedIds = sortOptions != null ? this.getSearchManager().sortIDs(ids, sortOptions) : new ArrayList<Long>(ids);
        if (sortedIds.size() < ids.size()) {
            LinkedHashSet<Long> combiningSet = new LinkedHashSet<Long>(sortedIds);
            combiningSet.addAll(ids);
            toPage = new ArrayList<Long>(combiningSet);
        } else {
            toPage = sortedIds;
        }
        Integer foFromRecord = fetchOptions.getFrom();
        Integer foRecordsCount = fetchOptions.getCount();
        boolean bl = hasPaging = foFromRecord != null || foRecordsCount != null;
        if (hasPaging) {
            int fromRecord = foFromRecord != null ? foFromRecord : 0;
            int toRecord = foRecordsCount != null ? Math.min(fromRecord + foRecordsCount, toPage.size()) : toPage.size();
            return fromRecord <= toRecord ? toPage.subList(fromRecord, toRecord) : Collections.emptyList();
        }
        return toPage;
    }

    private static void throwIllegalArgumentException(String message) throws RuntimeException {
        throw new IllegalArgumentException(message);
    }

    public ICacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

