/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEndsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class StringFieldMatcher<OBJECT>
extends Matcher<OBJECT> {
    @Override
    public List<OBJECT> getMatching(IOperationContext context, List<OBJECT> objects, ISearchCriteria criteria) {
        AbstractStringValue searchValueObject = (AbstractStringValue)((StringFieldSearchCriteria)criteria).getFieldValue();
        if (searchValueObject == null || searchValueObject.getValue() == null || searchValueObject instanceof AnyStringValue) {
            return objects;
        }
        String searchValue = ((String)searchValueObject.getValue()).toLowerCase();
        Pattern equalsPattern = StringFieldMatcher.createPattern(searchValue);
        Pattern startsPattern = StringFieldMatcher.createPattern(searchValue + "*");
        Pattern endsPattern = StringFieldMatcher.createPattern("*" + searchValue);
        Pattern containsPattern = StringFieldMatcher.createPattern("*" + searchValue + "*");
        ArrayList<OBJECT> matches = new ArrayList<OBJECT>();
        for (OBJECT object : objects) {
            boolean match;
            String actualValue = this.getFieldValue(object);
            actualValue = actualValue == null ? "" : actualValue.toLowerCase();
            if (searchValueObject instanceof StringEqualToValue) {
                match = equalsPattern.matcher(actualValue).matches();
            } else if (searchValueObject instanceof StringContainsValue) {
                match = containsPattern.matcher(actualValue).matches();
            } else if (searchValueObject instanceof StringStartsWithValue) {
                match = startsPattern.matcher(actualValue).matches();
            } else if (searchValueObject instanceof StringEndsWithValue) {
                match = endsPattern.matcher(actualValue).matches();
            } else {
                throw new IllegalArgumentException("Unknown string value: " + criteria.getClass());
            }
            if (!match) continue;
            matches.add(object);
        }
        return matches;
    }

    private static Pattern createPattern(String searchValue) {
        StringBuilder pattern = new StringBuilder();
        StringBuilder part = new StringBuilder();
        for (char c : searchValue.toCharArray()) {
            if (c == '*' || c == '?') {
                if (part.length() > 0) {
                    pattern.append(Pattern.quote(part.toString()));
                    part = new StringBuilder();
                }
                if (c == '*') {
                    pattern.append(".*");
                    continue;
                }
                pattern.append(".");
                continue;
            }
            part.append(c);
        }
        if (part.length() > 0) {
            pattern.append(Pattern.quote(part.toString()));
        }
        return Pattern.compile(pattern.toString());
    }

    protected abstract String getFieldValue(OBJECT var1);
}

