/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CacheOptionsVO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICacheManager;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="cache-manager")
public class CacheManager
implements ICacheManager {
    private final Map<String, ICache<Object>> cacheByUserSessionToken = new ConcurrentHashMap<String, ICache<Object>>();
    private Properties serviceProperties;
    private int cacheCapacity = 10240;
    private Class<?> cacheClass;

    @Override
    public ICache<Object> getCache(IOperationContext context) {
        String sessionToken = context.getSession().getSessionToken();
        ICache cache = this.cacheByUserSessionToken.get(sessionToken);
        if (cache == null) {
            try {
                cache = (ICache)this.cacheClass.getConstructor(CacheOptionsVO.class).newInstance(new CacheOptionsVO(this.cacheCapacity, this.serviceProperties, sessionToken, true, (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Error creating cache instance.", e);
            }
            this.cacheByUserSessionToken.put(sessionToken, cache);
        }
        return cache;
    }

    @Override
    public void clearCacheOfUser(String sessionToken) {
        ICache<Object> cache = this.cacheByUserSessionToken.get(sessionToken);
        if (cache != null) {
            cache.clear();
        }
        this.cacheByUserSessionToken.remove(sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOld(Date date) {
        Map<String, ICache<Object>> map = this.cacheByUserSessionToken;
        synchronized (map) {
            this.cacheByUserSessionToken.values().forEach(cache -> cache.clearOld(date.getTime()));
        }
    }

    @Override
    public Map<String, ICache<Object>> getCacheByUserSessionToken() {
        return this.cacheByUserSessionToken;
    }

    @Override
    public Class<?> getCacheClass() {
        return this.cacheClass;
    }

    @Override
    public void setCacheClass(Class<?> cacheClass) {
        this.cacheClass = cacheClass;
    }

    @Resource(name="propertyConfigurer")
    private void setServicePropertiesPlaceholder(ExposablePropertyPlaceholderConfigurer servicePropertiesPlaceholder) throws ClassNotFoundException {
        this.serviceProperties = servicePropertiesPlaceholder.getResolvedProps();
        this.cacheCapacity = PropertyUtils.getInt((Properties)this.serviceProperties, (String)"api.v3.operation-execution.cache.capacity", (int)10240);
        String cacheImplementationClassName = PropertyUtils.getProperty((Properties)this.serviceProperties, (String)"api.v3.operation-execution.cache.class");
        this.setCacheClass(cacheImplementationClassName != null ? Class.forName(cacheImplementationClassName) : null);
    }
}

