/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CacheOptionsVO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ITestableCache;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.log4j.Logger;

public class FileCache<V>
implements ITestableCache<V> {
    private static final Logger OPERATION_LOG = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileCache.class);
    private static boolean instanceCreated = false;
    private final int capacity;
    private final Queue<String> keyQueue;
    private final Set<String> writingKeys = new CopyOnWriteArraySet<String>();
    private final String cacheDirPath;
    private final File cacheDir;
    private final boolean asyncStorage;
    private final ITimeProvider timeProvider;

    public FileCache(CacheOptionsVO cacheOptionsVO) {
        this(cacheOptionsVO, PropertyUtils.getProperty((Properties)cacheOptionsVO.getServiceProperties(), (String)"api.v3.operation-execution.cache.directory", (String)"targets/sessionWorkspace/cache") + File.separator + cacheOptionsVO.getSessionToken().replaceAll("\\W+", ""));
    }

    FileCache(CacheOptionsVO cacheOptionsVO, String cacheDirPath) {
        this.timeProvider = cacheOptionsVO.getTimeProvider();
        this.asyncStorage = cacheOptionsVO.isAsyncStorage();
        int capacity = cacheOptionsVO.getCapacity();
        if (capacity < 0) {
            throw new RuntimeException("Capacity cannot be negative.");
        }
        this.capacity = capacity > 0 ? capacity : Integer.MAX_VALUE;
        this.keyQueue = capacity > 0 ? new ArrayDeque(this.capacity) : new ArrayDeque();
        this.cacheDirPath = cacheDirPath;
        this.cacheDir = new File(cacheDirPath);
        if (!instanceCreated) {
            instanceCreated = true;
            FileCache.deleteDir(this.cacheDir);
        }
        this.cacheDir.mkdirs();
        this.cacheDir.deleteOnExit();
    }

    @Override
    public synchronized void put(String key, V value) {
        if (!this.writingKeys.contains(key)) {
            this.writingKeys.add(key);
            boolean containsKey = this.contains(key);
            if (!containsKey) {
                String removedKey;
                boolean deleted;
                int queueSize = this.keyQueue.size();
                if (queueSize > this.capacity) {
                    throw new RuntimeException(String.format("Cash has exceeded the allocated capacity. [queueSize=%d, capacity=%d]", queueSize, this.capacity));
                }
                if (queueSize == this.capacity && !(deleted = this.getCacheFile(removedKey = this.keyQueue.remove()).delete())) {
                    String message = this.getCacheFile(removedKey).exists() ? String.format("The key removed from the queue cannot be removed from the cache. [removedKey=%s]", removedKey) : String.format("Cache file to remove is not found. [removedKey=%s]", removedKey);
                    throw new RuntimeException(message);
                }
            }
            this.storeValue(key, value);
            if (!containsKey) {
                this.keyQueue.add(key);
            }
            this.writingKeys.remove(key);
        }
    }

    private void storeValue(String key, V value) {
        File cacheFile = this.getCacheFile(key);
        cacheFile.deleteOnExit();
        Runnable fileOutputRunnable = () -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cacheFile));){
                out.writeObject(new ImmutablePair((Object)this.timeProvider.getTimeInMilliseconds(), value));
            }
            catch (IOException e) {
                OPERATION_LOG.error((Object)String.format("Error storing value in cache. [key=%s, value=%s]", key, value), (Throwable)e);
            }
        };
        if (this.asyncStorage) {
            new Thread(fileOutputRunnable).start();
        } else {
            fileOutputRunnable.run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized V get(String key) {
        File cacheFile = this.getCacheFile(key);
        if (!cacheFile.isFile()) return null;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(cacheFile));){
            ImmutablePair cachedResult = (ImmutablePair)in.readObject();
            Object object = cachedResult != null ? cachedResult.getRight() : null;
            return (V)object;
        }
        catch (IOException | ClassNotFoundException e) {
            OPERATION_LOG.error((Object)String.format("Error reading value from cache. [key=%s]", key), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized void remove(String key) {
        this.keyQueue.remove(key);
        this.getCacheFile(key).delete();
    }

    @Override
    public boolean contains(String key) {
        return this.getCacheFile(key).isFile();
    }

    @Override
    public synchronized void clear() {
        this.keyQueue.clear();
        try {
            FileUtils.cleanDirectory((File)this.cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot clean cache. [cacheDir=%s]", this.cacheDir), e);
        }
    }

    @Override
    public void clearOld(long time) {
        File[] files;
        File cacheDir = new File(this.cacheDirPath);
        for (File file : files = cacheDir.listFiles()) {
            ImmutablePair cachedResult;
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
                cachedResult = (ImmutablePair)in.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                OPERATION_LOG.error((Object)String.format("Error reading value from file. [file=%s]", file), (Throwable)e);
                cachedResult = null;
            }
            if (cachedResult == null || time <= (Long)cachedResult.getLeft()) continue;
            file.delete();
            this.keyQueue.removeIf(s -> Objects.equals(s, file.getName()));
        }
    }

    private File getCacheFile(String key) {
        return new File(this.cacheDirPath + File.separator + key.replaceAll("[^\\w-]+", ""));
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.stream(files).forEach(FileCache::deleteDir);
        }
        dir.delete();
    }

    @Override
    public Map<String, ImmutablePair<Long, V>> getCachedResults() {
        return null;
    }

    @Override
    public Queue<String> getKeyQueue() {
        return this.keyQueue;
    }
}

