/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CacheOptionsVO;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ITestableCache;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class MemoryCache<V>
implements ITestableCache<V> {
    private final int capacity;
    private final Map<String, ImmutablePair<Long, V>> cachedResults;
    private final Queue<String> keyQueue;
    private final Set<String> writingKeys = new CopyOnWriteArraySet<String>();
    private final ITimeProvider timeProvider;

    public MemoryCache(CacheOptionsVO cacheOptionsVO) {
        this.timeProvider = cacheOptionsVO.getTimeProvider();
        int capacity = cacheOptionsVO.getCapacity();
        if (capacity < 0) {
            throw new RuntimeException("Capacity cannot be negative.");
        }
        this.capacity = capacity > 0 ? capacity : Integer.MAX_VALUE;
        this.cachedResults = capacity > 0 ? new ConcurrentHashMap(this.capacity) : new ConcurrentHashMap();
        this.keyQueue = capacity > 0 ? new ArrayDeque(this.capacity) : new ArrayDeque();
    }

    @Override
    public synchronized void put(String key, V value) {
        if (!this.contains(key) && !this.writingKeys.contains(key)) {
            String removedKey;
            ImmutablePair<Long, V> removedValue;
            this.writingKeys.add(key);
            int cacheSize = this.cachedResults.size();
            int queueSize = this.keyQueue.size();
            if (cacheSize != queueSize) {
                throw new RuntimeException(String.format("Cache size and queue size differ. [cashSize=%d, queueSize=%d]", cacheSize, queueSize));
            }
            if (cacheSize > this.capacity) {
                throw new RuntimeException(String.format("Cash has exceeded the allocated capacity. [cashSize=%d, capacity=%d]", cacheSize, this.capacity));
            }
            if (cacheSize == this.capacity && (removedValue = this.cachedResults.remove(removedKey = this.keyQueue.remove())) == null) {
                throw new RuntimeException(String.format("The key removed from the queue cannot be found in the cache. [removedKey=%s]", removedKey));
            }
            this.keyQueue.add(key);
            this.writingKeys.remove(key);
        }
        this.cachedResults.put(key, new ImmutablePair((Object)this.timeProvider.getTimeInMilliseconds(), value));
    }

    @Override
    public V get(String key) {
        ImmutablePair<Long, V> cachedResult = this.cachedResults.get(key);
        return (V)(cachedResult != null ? cachedResult.getRight() : null);
    }

    @Override
    public synchronized void remove(String key) {
        this.keyQueue.remove(key);
        this.cachedResults.remove(key);
    }

    @Override
    public boolean contains(String key) {
        return this.cachedResults.containsKey(key);
    }

    @Override
    public synchronized void clear() {
        this.cachedResults.clear();
        this.keyQueue.clear();
    }

    @Override
    public synchronized void clearOld(long time) {
        Iterator<Map.Entry<String, ImmutablePair<Long, V>>> iterator = this.cachedResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (time <= (Long)entry.getValue().getLeft()) continue;
            iterator.remove();
            this.keyQueue.removeIf(s -> Objects.equals(s, entry.getKey()));
        }
    }

    @Override
    public Map<String, ImmutablePair<Long, V>> getCachedResults() {
        return this.cachedResults;
    }

    @Override
    public Queue<String> getKeyQueue() {
        return this.keyQueue;
    }
}

