/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.update;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import java.util.Collection;
import java.util.Map;

public abstract class UpdateFieldWithListUpdateValueExecutor<K, V> {
    protected void update(IOperationContext context, Map<K, IdListUpdateValue<V>> listUpdateMap) {
        for (Map.Entry<K, IdListUpdateValue<V>> listUpdateEntry : listUpdateMap.entrySet()) {
            K key = listUpdateEntry.getKey();
            IdListUpdateValue<V> listUpdate = listUpdateEntry.getValue();
            if (listUpdate == null || !listUpdate.hasActions()) continue;
            for (ListUpdateValue.ListUpdateAction action : listUpdate.getActions()) {
                if (action instanceof ListUpdateValue.ListUpdateActionSet) {
                    this.setValues(context, key, action.getItems());
                    continue;
                }
                if (action instanceof ListUpdateValue.ListUpdateActionAdd) {
                    this.addValues(context, key, action.getItems());
                    continue;
                }
                if (!(action instanceof ListUpdateValue.ListUpdateActionRemove)) continue;
                this.removeValues(context, key, action.getItems());
            }
        }
    }

    protected abstract void setValues(IOperationContext var1, K var2, Collection<? extends V> var3);

    protected abstract void addValues(IOperationContext var1, K var2, Collection<? extends V> var3);

    protected abstract void removeValues(IOperationContext var1, K var2, Collection<? extends V> var3);
}

