/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.verify;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.CreateObjectsOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.UpdateObjectsOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.verify.IVerifyObjectsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class VerifyObjectsOperationExecutor<ID extends IObjectId>
implements IVerifyObjectsOperationExecutor {
    @Override
    public void verify(IOperationContext context, List<? extends IOperation> operations, Map<IOperation, IOperationResult> results) {
        LinkedHashSet allIds = new LinkedHashSet();
        Class<CreateObjectsOperationResult<ID>> createObjectsOperationResultClass = this.getCreateObjectsOperationResultClass();
        Class<UpdateObjectsOperationResult<ID>> updateObjectsOperationResultClass = this.getUpdateObjectsOperationResultClass();
        for (IOperation iOperation : operations) {
            List ids;
            IOperationResult result = results.get(iOperation);
            if (result == null) continue;
            if (createObjectsOperationResultClass.isAssignableFrom(result.getClass())) {
                ids = ((CreateObjectsOperationResult)result).getObjectIds();
                allIds.addAll(ids);
                continue;
            }
            if (!updateObjectsOperationResultClass.isAssignableFrom(result.getClass())) continue;
            ids = ((UpdateObjectsOperationResult)result).getObjectIds();
            allIds.addAll(ids);
        }
        CollectionBatch batch = new CollectionBatch(0, 0, allIds.size(), allIds, allIds.size());
        this.doVerify(context, batch);
    }

    protected abstract Class<? extends CreateObjectsOperationResult<? extends ID>> getCreateObjectsOperationResultClass();

    protected abstract Class<? extends UpdateObjectsOperationResult<? extends ID>> getUpdateObjectsOperationResultClass();

    protected abstract void doVerify(IOperationContext var1, CollectionBatch<ID> var2);
}

