/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetPEByExperimentOrSampleIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractArchiveUnarchiveDataSetExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    protected IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;

    AbstractArchiveUnarchiveDataSetExecutor() {
    }

    protected void doArchiveUnarchive(IOperationContext context, List<? extends IDataSetId> dataSetIds, Object options, IArchiveUnarchiveAction action) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (dataSetIds == null) {
            throw new IllegalArgumentException("Data set ids cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Options cannot be null");
        }
        Map dataSetMap = this.mapDataSetByIdExecutor.map(context, dataSetIds);
        HashSet<String> dataSetCodes = new HashSet<String>();
        for (IDataSetId iDataSetId : dataSetIds) {
            DataPE dataSet = (DataPE)dataSetMap.get(iDataSetId);
            if (dataSet == null) {
                throw new ObjectNotFoundException((IObjectId)iDataSetId);
            }
            this.assertAuthorization(context, iDataSetId, dataSet);
            if (dataSetCodes.contains(dataSet.getCode())) continue;
            DataSetPEByExperimentOrSampleIdentifierValidator validator = new DataSetPEByExperimentOrSampleIdentifierValidator();
            validator.init(new AuthorizationDataProvider(this.daoFactory));
            if (!validator.doValidation(context.getSession().tryGetPerson(), dataSet)) {
                throw new UnauthorizedObjectAccessException((IObjectId)iDataSetId);
            }
            dataSetCodes.add(dataSet.getCode());
        }
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(context.getSession());
        dataSetTable.loadByDataSetCodes(new ArrayList<String>(dataSetCodes), false, true);
        action.execute(dataSetTable);
    }

    protected abstract void assertAuthorization(IOperationContext var1, IDataSetId var2, DataPE var3);

    public static interface IArchiveUnarchiveAction {
        public void execute(IDataSetTable var1);
    }
}

