/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.archive.DataSetArchiveOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.AbstractArchiveUnarchiveDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IArchiveDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchiveDataSetExecutor
extends AbstractArchiveUnarchiveDataSetExecutor
implements IArchiveDataSetExecutor {
    @Autowired
    private IDataSetAuthorizationExecutor authorizationExecutor;

    @Override
    public void archive(IOperationContext context, List<? extends IDataSetId> dataSetIds, final DataSetArchiveOptions options) {
        this.doArchiveUnarchive(context, dataSetIds, options, new AbstractArchiveUnarchiveDataSetExecutor.IArchiveUnarchiveAction(){

            @Override
            public void execute(IDataSetTable dataSetTable) {
                dataSetTable.archiveDatasets(options.isRemoveFromDataStore(), options.getOptions());
            }
        });
    }

    @Override
    protected void assertAuthorization(IOperationContext context, IDataSetId dataSetId, DataPE dataSet) {
        this.authorizationExecutor.canArchive(context, dataSetId, dataSet);
    }
}

