/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ICreateDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetChildrenExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetComponentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetDataStoreExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetParentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetPhysicalDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IUpdateEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IAddTagToEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckDataProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IPermIdDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateDataSetExecutor
extends AbstractCreateEntityExecutor<DataSetCreation, DataPE, DataSetPermId>
implements ICreateDataSetExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IDataSetAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapEntityTypeByIdExecutor mapEntityTypeByIdExecutor;
    @Autowired
    private ISetDataSetPhysicalDataExecutor setDataSetPhysicalDataExecutor;
    @Autowired
    private ISetDataSetLinkedDataExecutor setDataSetLinkedDataExecutor;
    @Autowired
    private ISetDataSetDataStoreExecutor setDataSetDataStoreExecutor;
    @Autowired
    private ISetDataSetExperimentExecutor setDataSetExperimentExecutor;
    @Autowired
    private ISetDataSetSampleExecutor setDataSetSampleExecutor;
    @Autowired
    private ISetDataSetContainerExecutor setDataSetContainerExecutor;
    @Autowired
    private ISetDataSetComponentsExecutor setDataSetComponentsExecutor;
    @Autowired
    private ISetDataSetParentsExecutor setDataSetParentsExecutor;
    @Autowired
    private ISetDataSetChildrenExecutor setDataSetChildrenExecutor;
    @Autowired
    private IUpdateEntityPropertyExecutor updateEntityPropertyExecutor;
    @Autowired
    private IAddTagToEntityExecutor addTagToEntityExecutor;

    @Override
    protected List<DataPE> createEntities(final IOperationContext context, CollectionBatch<DataSetCreation> batch) {
        final Map<IEntityTypeId, EntityTypePE> types = this.getTypes(context, batch);
        this.checkData(context, batch, types);
        final IPermIdDAO codeGenerator = this.daoFactory.getPermIdDAO();
        final LinkedList<DataPE> dataSets = new LinkedList<DataPE>();
        new CollectionBatchProcessor<DataSetCreation>(context, batch){

            @Override
            public void process(DataSetCreation creation) {
                DataSetTypePE type = (DataSetTypePE)types.get(creation.getTypeId());
                if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
                    creation.setCode(codeGenerator.createPermId());
                }
                DataSetKind kind = this.determineDataSetKind(creation);
                DataPE dataSet = null;
                if (DataSetKind.PHYSICAL.equals((Object)kind)) {
                    dataSet = new ExternalDataPE();
                } else if (DataSetKind.CONTAINER.equals((Object)kind)) {
                    dataSet = new DataPE();
                } else if (DataSetKind.LINK.equals((Object)kind)) {
                    dataSet = new LinkDataPE();
                }
                dataSet.setCode(creation.getCode());
                dataSet.setDataSetKind(kind.name());
                dataSet.setDataSetType(type);
                dataSet.setDerived(false == creation.isMeasured());
                dataSet.setDataProducerCode(creation.getDataProducer());
                dataSet.setProductionDate(creation.getDataProductionDate());
                PersonPE person = context.getSession().tryGetPerson();
                dataSet.setRegistrator(person);
                Date timeStamp = CreateDataSetExecutor.this.daoFactory.getTransactionTimestamp();
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet, person, timeStamp);
                dataSets.add(dataSet);
            }

            private DataSetKind determineDataSetKind(DataSetCreation creation) {
                if (creation.getDataSetKind() != null) {
                    return creation.getDataSetKind();
                }
                if (creation.getLinkedData() != null) {
                    return DataSetKind.LINK;
                }
                return DataSetKind.PHYSICAL;
            }

            @Override
            public IProgress createProgress(DataSetCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return dataSets;
    }

    private Map<IEntityTypeId, EntityTypePE> getTypes(IOperationContext context, CollectionBatch<DataSetCreation> batch) {
        HashSet<IEntityTypeId> typeIds = new HashSet<IEntityTypeId>();
        for (DataSetCreation creation : (Collection)batch.getObjects()) {
            typeIds.add(creation.getTypeId());
        }
        return this.mapEntityTypeByIdExecutor.map(context, EntityKind.DATA_SET, typeIds);
    }

    private void checkData(IOperationContext context, CollectionBatch<DataSetCreation> batch, final Map<IEntityTypeId, EntityTypePE> types) {
        new CollectionBatchProcessor<DataSetCreation>(context, batch){

            @Override
            public void process(DataSetCreation creation) {
                EntityTypePE type = (EntityTypePE)types.get(creation.getTypeId());
                if (type == null) {
                    throw new ObjectNotFoundException((IObjectId)creation.getTypeId());
                }
                if (StringUtils.isEmpty((CharSequence)creation.getCode()) && !creation.isAutoGeneratedCode()) {
                    throw new UserFailureException("Code cannot be empty for a non auto generated code.");
                }
                if (!StringUtils.isEmpty((CharSequence)creation.getCode()) && creation.isAutoGeneratedCode()) {
                    throw new UserFailureException("Code should be empty when auto generated code is selected.");
                }
            }

            @Override
            public IProgress createProgress(DataSetCreation object, int objectIndex, int totalObjectCount) {
                return new CheckDataProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void checkData(IOperationContext context, DataSetCreation creation) {
        if (creation.getTypeId() == null) {
            throw new UserFailureException("Type id cannot be null.");
        }
        if (creation.getExperimentId() == null && creation.getSampleId() == null) {
            throw new UserFailureException("Experiment id and sample id cannot be both null.");
        }
    }

    @Override
    protected DataSetPermId createPermId(IOperationContext context, DataPE entity) {
        return new DataSetPermId(entity.getPermId());
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, DataPE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<DataSetCreation, DataPE> batch) {
        this.setDataSetPhysicalDataExecutor.set(context, batch);
        this.setDataSetLinkedDataExecutor.set(context, batch);
        this.setDataSetDataStoreExecutor.set(context, batch);
        this.setDataSetSampleExecutor.set(context, batch);
        this.setDataSetExperimentExecutor.set(context, batch);
        this.updateEntityPropertyExecutor.update(context, batch);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<DataSetCreation, DataPE> batch) {
        HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>> tagMap = new HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            DataSetCreation creation = (DataSetCreation)entry.getKey();
            DataPE entity = (DataPE)entry.getValue();
            tagMap.put(entity, creation.getTagIds());
        }
        this.addTagToEntityExecutor.add(context, tagMap);
        this.setDataSetChildrenExecutor.set(context, batch);
        this.setDataSetParentsExecutor.set(context, batch);
        this.setDataSetComponentsExecutor.set(context, batch);
        this.setDataSetContainerExecutor.set(context, batch);
    }

    @Override
    protected List<DataPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getDataDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<DataPE> entities, boolean clearCache) {
        this.daoFactory.getDataDAO().createDataSets(entities, context.getSession().tryGetPerson());
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.DATA_SET.getLabel(), EntityKind.DATA_SET);
    }

    @Override
    protected IObjectId getId(DataPE entity) {
        return new DataSetPermId(entity.getPermId());
    }
}

